#include "hash.h"
#include "lista.h"
#define RAIO 4
//---------------------------------------------------------------------------
#ifndef GrafoH
#define GrafoH
//---------------------------------------------------------------------------

class TeSTElementSet;

class TSkaterGrafo {

public:

    typedef struct No_Grafo{
      char Label[50];
      double X;
      double Y;
      TListaVizinho *Vizinhos;
      TListaVizinho *ArViz;
      double *Variaveis;
      int Populacao;
      char Mark;
    } Grafo_t, *Grafo_ptr;

    typedef struct Grafo{
       Grafo_ptr Nos;
       int Num_Var;
       int Size;
    }MyGrafo_t,*MyGrafo_ptr;

/**** Funcoes Publicas ****/
 TSkaterGrafo(bool hasPop);
 bool  MontaGrafo(TeSTElementSet& regSet);
 void  Escalona(double *,double *);
 void  Escala(int,int);
 void  Adjacente(int *,double *,int i);
 void  Adjacente1(int *,double *,int i);
 int Size() {return GetSize();}
 double MinX() {return X_min;}
 double MaxX() {return X_max;}
 double MinY() {return Y_min;}
 double MaxY() {return Y_max;}
 double Coord_X(int Indice){return Get_X(Indice);}
 double Coord_Y(int Indice) {return Get_Y(Indice);}
 int Num_Var() {return GetNum_Var();}


 /***** Area Privada *****/
private:
    MyGrafo_ptr MyGrafo;
    THash *Hash;
    double X_min,X_max;//Usado para conversao de escala
    double Y_min,Y_max;//Usado para conversao de escala
    double Cx,Gamax;   //Usados na conversao de escala
    double Cy,Gamay;   //Usados na conversao de escala

    double  Distancia(int,int);
    double  Get_X(int Indice);
    double  Get_Y(int Indice);
    int GetSize();
    int  GetNum_Var();

     //Variaveis que sao inicializadas de fora
    char *NArq;
    char *NViz;
    char Tem_Pop;

    friend class TArvore;
    friend class TParticao;
    friend class TPrincipal;
    friend class TEstatistica;
};

#endif
