
#include "TeSTEvent.h"
#include "TeTheme.h"
#include "TeTimeInterval.h"
	

TeSTEvent::TeSTEvent(const string& objId, const TePoint& point, const long& time):
		object_id_(objId),
		point_(point),
		time_(time)
{
	unique_id_.push_back (objId);
}

TeSTEvent::TeSTEvent(const string& objId, const TePoint& point, const vector<double>& attrValue, 
					 const vector<TeAttributeRep>& attrRep, const long& time):
		object_id_(objId),
		point_(point),
		time_(time),
		attrValue_(attrValue),
		attrRep_(attrRep)
{
	unique_id_.push_back (objId);
}

TeSTEvent::TeSTEvent(const TeSTEvent& other) 
{	
	unique_id_		= other.unique_id_;
	object_id_		= other.object_id_;
	time_			= other.time_;
	point_			= other.point_;  
	attrValue_		= other.attrValue_;
	attrRep_		= other.attrRep_;
	theme_			= other.theme_;
	attrOut_		= other.attrOut_;
}
			
TeSTEvent&					
TeSTEvent::operator= (const TeSTEvent& other)
{	
	if ( this != &other )
	{
		unique_id_		= other.unique_id_;
		object_id_		= other.object_id_;
		time_			= other.time_;
		point_			= other.point_;  
		attrValue_		= other.attrValue_;
		attrRep_		= other.attrRep_;
		theme_			= other.theme_;
		attrOut_		= other.attrOut_;
	}
	return *this;
}
	
	
bool 
TeSTEvent::operator== (const TeSTEvent& other) const
{	
	if (this->object_id_ != other.object_id_ || 
		!(this->time_ == other.time_) ||
		(this->point_.location().x() != other.point_.location().x()) ||
		(this->point_.location().y() != other.point_.location().y()))
		return false;

	return true; 
}


TeTheme* 
TeSTEvent::theme()
{	
	return theme_; 
}

void 
TeSTEvent::theme(TeTheme* t)
{
	theme_ = t;
}

TeTimeInterval 
TeSTEvent::timeInterval() 
{
	TeTimeInterval t;
	return t;
}

int 
TeSTEvent::getPropertyIndex(const string& name)
{
	vector<TeAttributeRep>::iterator itRep = attrRep_.begin();
	int index=-1;
	while (itRep!=attrRep_.end())
	{
		++index;
		if(itRep->name_==name)
			return index;
	}
	return index;
}


void 
TeSTEvent::setPropertyValue(const int& indexAttr, const double& value)
{
	if(attrValue_.empty())
		return; 

	if(indexAttr >(int)(attrValue_.size()-1))
		return;

	attrValue_[indexAttr] = value;
}

void 
TeSTEvent::addProperty(const TeProperty& prop, bool attrIn) 
{
	attrValue_.push_back(atof(prop.value_.c_str()));
	attrRep_.push_back(prop.attr_.rep_);
	if(!attrIn)
		attrOut_.push_back((attrValue_.size()-1));
}

void 
TeSTEvent::addProperty(const double& val, TeAttributeRep rep, bool attrIn)
{
	attrValue_.push_back(val);
	attrRep_.push_back(rep);
	if(!attrIn)
		attrOut_.push_back((attrValue_.size()-1));
}

TePropertyVector 
TeSTEvent::getOutPropertyVector()
{
	TePropertyVector vec;
	for(unsigned int i=0; i<attrOut_.size(); ++i)
	{
		TeProperty prop;
		prop.attr_.rep_ = attrRep_[attrOut_[i]];
		prop.value_ = Te2String(attrValue_[attrOut_[i]]);
		vec.push_back (prop);
	}
	return vec;
}

TePropertyVector 
TeSTEvent::getPropertyVector()
{
	TePropertyVector vec;
	for(unsigned int i=0; i<attrValue_.size(); ++i)
	{
		TeProperty prop;
		prop.attr_.rep_ = attrRep_[i];
		prop.value_ = Te2String(attrValue_[i]);
		vec.push_back (prop);
	}
	return vec;
}

bool 
TeSTEvent::getPropertyValue (string& val, int i)
{
	if ((i>=0) && (i<(int)attrValue_.size()))
	{
		val = Te2String(attrValue_[i]);
		return true;
	}
	else
		return false;
}

//------------------------------------------ TeSTEventSet

TeTheme* 
TeSTEventSet::theme()
{	
	return theme_; 
}

void 
TeSTEventSet::theme(TeTheme* t)
{
	theme_ = t;
}

unsigned int 
TeSTEventSet::size()
{ 
	return eventSet_.size(); 
}

bool
TeSTEventSet::getAttributeValue (const string& object_id, const string& attr_name, string& val, TeTimeInterval /* time */)
{
	int index = getAttributeIndex(attr_name);
	if(index<0)
		return false;
	
	double vald = 0.;
	bool status =  getAttributeValue (object_id,  index, vald);
	val = Te2String(vald);
	return status;
}
	
bool 
TeSTEventSet::getAttributeValue (const string& object_id, int attr_index, string& val, TeTimeInterval /* time */)
{
	double vald = 0.;
	bool status =  getAttributeValue (object_id,  attr_index, vald);
	val = Te2String(vald);
	return status;
}


bool 
TeSTEventSet::getAttributeValue (const string& object_id, int attr_index, double& val,	long /* time */)
{
	
	STElemIterator it = eventSet_.find(object_id);
	if(it==eventSet_.end())
		return false;

	val = (it->second).getPropertyValue(attr_index);
	return true;
}

int 
TeSTEventSet::getAttributeIndex(const string& attrName)
{
	STElemIterator it = eventSet_.begin();
	return(it->second.getPropertyIndex(attrName));
}
		
TeSTEventSet::iterator& 
TeSTEventSet::iterator::operator++()
{
	if(curElem_!=elemSet_->eventSet_.end())
		++curElem_;
	return (*this);
}


TeSTEventSet::iterator 
TeSTEventSet::begin()     
{ 
	return iterator(this, eventSet_.begin());
}


TeSTEventSet::iterator 
TeSTEventSet::end()       
{
	return iterator(this, eventSet_.end());
}


void 
TeSTEventSet::insertSTInstance(TeSTEvent& ev)
{ 
	string obj = ev.objectId();
	eventSet_[obj] = ev; 
}







