/************************************************************************************
TerraView - visualization and exploration of geographical databases
using TerraLib.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.
This file is part of TerraView. TerraView is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

You should have received a copy of the GNU General Public License
along with TerraView.
The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The software provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of
this program and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QTDATABASESLISTVIEW_H
#define  __TERRALIB_INTERNAL_QTDATABASESLISTVIEW_H


#include <qlistview.h>

class QPopupMenu;
class TeQtCheckListItem;
class TeQtDatabaseItem;
class TeQtLayerItem;
class TeLayer;


class TeQtDatabasesListView : public QListView
{
	Q_OBJECT

public:
    TeQtDatabasesListView(QWidget *parent = 0, const char *name = 0);

	~TeQtDatabasesListView();

	TeQtDatabaseItem* currentDatabaseItem() 
		{ return currentDatabaseItem_; }

	TeQtLayerItem* currentLayerItem() 
		{ return currentLayerItem_; }

	TeQtCheckListItem *popupItem()
		{ return popupItem_; }

	QPopupMenu* popupDatabase()
		{ return popupDatabase_; }

	QPopupMenu* popupLayer()
		{ return popupLayer_; }

	QPopupMenu* popupOutItem()
		{ return popupOutItem_; }

	void selectItem(QListViewItem *item);

	void selectLayerItem(TeLayer *layer);

	void removeItem(QListViewItem *item);

signals:
	void itemChanged(QListViewItem*);
	void popupSignal();

protected slots:
	void clicked(QListViewItem *item);
	void contextMenuRequested(QListViewItem*, const QPoint&, int);

protected:
	TeQtDatabaseItem	*currentDatabaseItem_;
	TeQtLayerItem		*currentLayerItem_;
	bool				rightMouseWasClicked_;
	TeQtCheckListItem	*popupItem_;
	QPopupMenu			*popupDatabase_;
	QPopupMenu			*popupLayer_;
	QPopupMenu			*popupOutItem_;

	void contentsMousePressEvent(QMouseEvent *e);

	void unselectAllItems();
};


#endif

