#include "TePDIParameters.hpp"

#include "TePDIAgnostic.hpp"

TePDIParameters::TePDIParameters()
{

}


TePDIParameters::~TePDIParameters()
{

}

void TePDIParameters::SetParameter( const std::string& pname,
  const TePDITypes::TePDIRasterPtrType& data )
{
  unsigned int old_size = RasterMap_.size();

  RasterMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != RasterMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
  TePDITypes::TePDIRasterPtrType& data ) const
{
  TePDIRasterMap::iterator it = RasterMap_.find( pname );

  if( it != RasterMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}


void TePDIParameters::SetParameter( const std::string& pname,
  TePDIRgbPalette::const_pointer& data )
{
  unsigned int old_size = PDIRgbPaletteMap_.size();

  PDIRgbPaletteMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != PDIRgbPaletteMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
  TePDIRgbPalette::pointer& data ) const
{
  TePDIRgbPaletteMap::iterator it = PDIRgbPaletteMap_.find( pname );

  if( it != PDIRgbPaletteMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}


void TePDIParameters::SetParameter( const std::string& pname,
                                    int data )
{
  unsigned int old_size = IntegerMap_.size();

  IntegerMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != IntegerMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
                                    int& data ) const
{
  TePDIIntegerMap::iterator it = IntegerMap_.find( pname );

  if( it != IntegerMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}

void TePDIParameters::SetParameter( const std::string& pname,
                                    std::vector< int >& data )
{
  unsigned int old_size = IntegerVectorMap_.size();

  IntegerVectorMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != IntegerVectorMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
                                    std::vector< int >& data ) const
{
  TePDIIntegerVectorMap::iterator it = IntegerVectorMap_.find( pname );

  if( it != IntegerVectorMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}

void TePDIParameters::SetParameter( const std::string& pname,
                                    const std::string& data )
{
  unsigned int old_size = StringMap_.size();

  StringMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != StringMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
                                    std::string& data ) const
{
  TePDIStringMap::iterator it = StringMap_.find( pname );

  if( it != StringMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}

void TePDIParameters::SetParameter( const std::string& pname,
                                    double data )
{
  unsigned int old_size = DoubleMap_.size();

  DoubleMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != DoubleMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
                                    double& data ) const
{
  TePDIDoubleMap::iterator it = DoubleMap_.find( pname );

  if( it != DoubleMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}

void TePDIParameters::SetParameter( const std::string& pname,
                                    const TePDIBox::pointer& data )
{
  unsigned int old_size = PDIBoxMap_.size();

  PDIBoxMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != PDIBoxMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
                                    TePDIBox::pointer& data ) const
{
  TePDIBoxMap::iterator it = PDIBoxMap_.find( pname );

  if( it != PDIBoxMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}

void TePDIParameters::SetParameter( const std::string& pname,
                                    const TePDIFilterMask::pointer& data )
{
  unsigned int old_size = PDIFilterMaskMap_.size();

  PDIFilterMaskMap_[ pname ] = data;

  PDIAGN_TRUE_OR_THROW( old_size != PDIFilterMaskMap_.size(),
    "Insertion failed." );
}


bool TePDIParameters::GetParameter( const std::string& pname,
                                    TePDIFilterMask::pointer& data ) const
{
  TePDIFilterMaskMap::iterator it = PDIFilterMaskMap_.find( pname );

  if( it != PDIFilterMaskMap_.end() ) {
    data = it->second;
    return true;
  }

  PDIAGN_LOGERR( "Invalid get: Parameter not stored" );

  return false;
}

bool TePDIParameters::CheckParameter( const std::string& pname,
                                      TePDIParamTypes type ) const
{
  switch( type ) {
    case TePDIIntParam :
    {
      if( IntegerMap_.find( pname ) != IntegerMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIIntVectorParam :
    {
      if( IntegerVectorMap_.find( pname ) != IntegerVectorMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIRasterParam :
    {
      if( RasterMap_.find( pname ) != RasterMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIStringParam :
    {
      if( StringMap_.find( pname ) != StringMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIDoubleParam :
    {
      if( DoubleMap_.find( pname ) != DoubleMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIBoxParam :
    {
      if( PDIBoxMap_.find( pname ) != PDIBoxMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIRgbPaletteParam :
    {
      if( PDIRgbPaletteMap_.find( pname ) != PDIRgbPaletteMap_.end() ){
        return true;
      }
      break;
    }
    case TePDIFilterMaskParam :
    {
      if( PDIFilterMaskMap_.find( pname ) != PDIFilterMaskMap_.end() ){
        return true;
      }
      break;
    }    default :
    {
      PDIAGN_LOG_AND_THROW( "Invalid Parameter Type" );
      break;
    }
  }

  return false;
}

void TePDIParameters::operator=( const TePDIParameters& ext_params )
{
  RasterMap_ = ext_params.RasterMap_;
  IntegerMap_ = ext_params.IntegerMap_;
  IntegerVectorMap_ = ext_params.IntegerVectorMap_;
  StringMap_ = ext_params.StringMap_;
  DoubleMap_ = ext_params.DoubleMap_;
  PDIBoxMap_ = ext_params.PDIBoxMap_;
  PDIRgbPaletteMap_ = ext_params.PDIRgbPaletteMap_;
  PDIFilterMaskMap_ = ext_params.PDIFilterMaskMap_;
}
