#include "TePDIAlgorithm.hpp"

#include "TePDIAgnostic.hpp"

TePDIAlgorithm::TePDIAlgorithm()
{
}

TePDIAlgorithm::TePDIAlgorithm( const TePDIParameters& params )
{
  Reset( params );
}


TePDIAlgorithm::~TePDIAlgorithm()
{
}


bool TePDIAlgorithm::Reset( const TePDIParameters& params )
{
  ResetState();

  if( CheckParameters( params ) ) {
    params_ = params;
    return true;
  } else {
    PDIAGN_LOGERR( "Invalid supplied parameters" );
    return false;
  }
}


bool TePDIAlgorithm::Apply()
{
  if( CheckParameters( params_ ) ) {
    return RunImplementation();
  } else {
    PDIAGN_LOGERR( "Invalid supplied parameters" );
    return false;
  }
}
