/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides a new type of list (a <i>cell list</i>) and a generic list model.
 * A cell list uses a normal list model, but displays the list elements in a grid
 * where each list element is displayed as an icon/text pair. (Similar to the 
 * cells of a file browser which display each file as an icon and a file name.)<p>
 *
 * A special {@link be.ugent.caagt.swirl.lists.CellListCellRenderer} determines
 * which icon and what text is displayed for each element. These renderers work best
 * when the list elements implement the {@link be.ugent.caagt.swirl.lists.CellListCellValue}
 * interface.<p>
 *
 * Additionally, this package provides the class 
 * {@link be.ugent.caagt.swirl.lists.ArrayListModel},
 * a {@link javax.swing.ListModel} which is at the same time
 * an implementation of {@link java.util.List} from the Java Collections API.
 */
package be.ugent.caagt.swirl.lists;

