/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: macros.h,v 1.4 2001/09/29 15:13:09 michael Exp $ */

#ifndef MACROS_H
#define MACROS_H 1

#define ERROR(code,todo) \
  { libsnsp_errno = code; \
    { todo } }

/* Paranoia String Macros ^_^ */

#define SSTRCPY(dst,src,cnt,todo) \
  if ((cnt-=strlen(src)) <= 0) { \
    todo \
  } else { \
    strncpy(dst,src,cnt-1); \
    dst[cnt-1] = '\0'; \
  }

#define SSTRCAT(dst,src,cnt,todo) \
  if ((cnt-=strlen(src)) <= 0) { \
    todo \
  } else { \
    strncat(dst,src,cnt-1); \
    dst[cnt-1] = '\0'; \
  }

#define SSTRLEN(str,max) \
  ((strlen(str) >= max) ? 0 : (strlen(str)))

#define IFMAX(cnt,max,todo) \
  if (cnt > max) \
    todo

#endif /* MACROS_H */
