/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: cmd.h,v 1.1.1.1 2001/09/25 00:33:29 michael Exp $ */

#ifndef CMD_H
#define CMD_H 1

#include <stdarg.h>

#include "linkedlist.h"
#include "reply.h"

#include "const.h"

typedef struct snsp_cmd {
	char			              *cmd;
	LINKED_LIST_T(char*)		*parameters;
} snsp_cmd_t;

snsp_cmd_t* snsp_cmd_alloc ();
void snsp_cmd_free ( snsp_cmd_t **cmd );

char* snsp_cmd_render ( snsp_cmd_t *cmd );
snsp_cmd_t* snsp_cmd_parse ( char *cmd_str );

snsp_cmd_t* snsp_cmd_create ( char *cmd_cmd, ... );
	
#endif /* CMD_H */
