/*
  ROXEN USER POLL MODULE ; "RoxPoll".

  Version: 1.3

  The latest version can always be found at http://www.abrahamsson.org/poll/

  Allows the users of your site to vote at polls, suggest new poll
  questions. It also contains a simple administrators interface and
  enough automatic behaviour to be easy to use for any stressed web
  master.

  Copyright (C) 1998 Thomas F Abrahamsson
  The Elfwood Project, thomas@elfwood.com (alt: celborn@lysator.liu.se)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  (Or look at http://www.gnu.ai.mit.edu/copyleft/gpl.html)

  Version History:
   v 1.0 : First Release; Should work OK. Even if it's not the world's
           most beautiful code, it should be pretty easy and fast to use.
	   Released Nov 8 1998.  
   v 1.1 : Internal Release.
   v 1.2 : Second Official Release. Customizable outlook. Negative remove-value
           now work + several clean'ups and finishing touches.
   v 1.3 : Roxen configuration. Better logging. Now Works on Pike 0.5 too...

  TODO:
  * Support for several poll-boxes, each one using an unique ID, on one site.
    :-(
  * Possibility to EDIT the suggested polls without having to go to a text editor.
  * Maybe more HTML flexibility for users, now much HTML is IN the tags.
  * more? mail thomas@abrahamsson.org
*/

#include <module.h>
inherit "module";
import Stdio;

constant thread_safe = 1;

void create()
{
  defvar("no_options", 6, "Number of default options",
	 TYPE_INT,
	 "How many options to default to at new suggestion form");

  defvar("full_search_path", "NONE", "Full search path for data files", 
	 TYPE_DIR,
	 "This is the path to the location where the module will "
	 "save the data files (in the real "+
	 "file system)");

  defvar("adminpassword", "secret", "Administrator password",
	 TYPE_STRING|VAR_MORE,
	 "Password to maintain the poll database online. "
	 "Note that this is a very LOW security password, so "
	 "don't use your regular password for this one and change often :)");

  defvar("base_url", "NONE", "Full URL to Roxpoll's base directory on the web server.",
	 TYPE_STRING|VAR_MORE,
	 "Full URL to Roxpoll's base directory on the web server.  example http://bla.bla.bla/roxpoll/");

  defvar("1_color", "#f0e040", "Color of headline text.",
	 TYPE_STRING|VAR_MORE,
	 "Color of headline text. This can either be a HTML color "
	 "name (like red) or a "
	 "full HTML-RGB value (like #ff9010) formatted as #rrggbb");

  defvar("2_color", "#403020", "Color of Table block bg.",
	 TYPE_STRING|VAR_MORE,
	 "Table block bg. This can either be a HTML color "
	 "name (like red) or a "
	 "full HTML-RGB value (like #ff9010) formatted as #rrggbb");

  defvar("3_color", "#4e8e0", "Color of body text.",
	 TYPE_STRING|VAR_MORE,
	 "body text color. This can either be a HTML color "
	 "name (like red) or a "
	 "full HTML-RGB value (like #ff9010) formatted as #rrggbb");

  defvar("4_color", "#102080", "Color of Headline bg.",
	 TYPE_STRING|VAR_MORE,
	 "Headline bg color. This can either be a HTML color "
	 "name (like red) or a "
	 "full HTML-RGB value (like #ff9010) formatted as #rrggbb");

  defvar("5_color", "#002000", "Color of bottom table cell bg.",
	 TYPE_STRING|VAR_MORE,
	 "bottom table cell bg color. This can either be a HTML color "
	 "name (like red) or a "
	 "full HTML-RGB value (like #ff9010) formatted as #rrggbb");

  defvar("5_color", "#002000", "Color of bottom table cell bg.",
	 TYPE_STRING|VAR_MORE,
	 "bottom table cell bg color. This can either be a HTML color "
	 "name (like red) or a "
	 "full HTML-RGB value (like #ff9010) formatted as #rrggbb");
}

// ----------------------------------------------------------------------------- 
// Change this HTML to suit your needs.
// ----------------------------------------------------------------------------- 

string prehtml()
{
  return 
    "\n\n<!--  RoxPoll Poll Entry Form Box -->\n"
    "<TABLE CELLSPACING=0 CELLPADDING=0 WIDTH=\"142\" BGCOLOR=\"#000000\" >"
    "<TR>"
    "<TD>"
    "<TABLE CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\" BGCOLOR=\""+(query("4_color"))+"\" >"
    "<TR BGCOLOR=\""+(query("2_color"))+"\">"
    "<TD ALIGN=LEFT VALIGN=TOP BGCOLOR=\""+(query("2_color"))+"\"></TD>"
    "<TD></TD>"
    "</TR>"
    "<TR BGCOLOR=\""+(query("4_color"))+"\">"
    "<TD ALIGN=CENTER VALIGN=TOP COLSPAN=\"2\" BGCOLOR=\""+(query("4_color"))+"\"><B>"
    "<FONT FACE=\"arial,helvetica\"><FONT COLOR=\""+(query("1_color"))+"\"><FONT SIZE=-1>"
    "Current user poll</FONT></FONT></FONT></B></TD>"
    "</TR>"
    "<TR BGCOLOR=\""+(query("2_color"))+"\">"
    "<TD ALIGN=LEFT VALIGN=TOP BGCOLOR=\""+(query("2_color"))+"\"></TD>"
    "<TD WIDTH=\"100%\">";
}

string posthtml()
{ 
  return    
    "</TD>"
    "</TR>"
    "<TR BGCOLOR=\""+(query("5_color"))+"\">"
    "<TD ALIGN=RIGHT BGCOLOR=\""+(query("5_color"))+"\"></TD>"
    "<TD ALIGN=RIGHT><FONT FACE=\"arial,helvetica\"><FONT COLOR=\""+(query("1_color"))+"\">"
    "<FONT SIZE=-2>[<A HREF=\""+query("base_url")+"results.html"+"?uniq="+time()+"&action=view_old\">Results</A>]"
    "[<A HREF=\""+query("base_url")+"suggest.html?uniq="+time()+""+"\">Suggest</A>]</FONT></FONT></FONT></TD>"
    "</TR>"
    "</TABLE>"
    "</TD>"
    "</TR>"
    "</TABLE>"
    "<!-- end of RoxPoll Poll Entry Form Box -->\n\n";
}


/* ----------------------------------------------------------------------------- */
/* ...but don't change these, please: */
/* ----------------------------------------------------------------------------- */
#define VER "v1.3"
#define HISTORY 0
#define CURRENT 1
#define SUGGESTED 2
#define SWPTIME 7
#define LEFTGIF  "vote_left.gif"
#define RIGHTGIF "vote_right.gif"
#define MIDDLEGIF "vote_middle.gif"
#define CNOT "<font face=arial,helvetica size=-2>"\
"The <a href=\"http://www.abrahamsson.org/poll/\">"\
"RoxPoll software</a> was written by Thomas Abrahamsson."\
"</font></font>"

int started = 0;
mapping history_polls = ([]);   /* Keeps this data in a mapping RAM */
mapping suggested_polls = ([]); /* Keeps this data in a mapping RAM */
mapping current_poll = ([]);    /* Keeps this data in a mapping RAM */
mapping voted_today = ([]);     /* Keeps this data in a mapping RAM */ 
object re_usable_file_object = File();
int running_poll_id=0;
int daycache = 0;
int lastavoid;

string filedbnames(int position)
{
  /* old,this,suggested */
  return ({ (query("full_search_path"))+"history_polls.dat", 
	      (query("full_search_path"))+"current_poll.dat", 
	      (query("full_search_path"))+"suggested_polls.dat" })[position];
}

/* ----------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------- */

string do_neat_table(mapping for_mapping, int which_id)
{
  string res;
  float total_vot;
  int intpercent;
  mapping temp = ([]);

  res="\n<!-- Results -->\n"
    "<table border=1 cellpadding=1 cellspacing=0>"
    "<tr><td colspan=3 valign=top align=center><font face=arial,helvetica size=+1>"
    "<b>\""+for_mapping[which_id]["qu"]+"\" ("+for_mapping[which_id]["to"]+" votes)</b></font>"
    "</td></tr>";
  foreach((indices(for_mapping[which_id]["re"])), int vote_id)
    total_vot+=((float)(temp[vote_id]=((for_mapping[which_id]["re"])[vote_id])["vot"]));

  /*    total_vot = (float)for_mapping[which_id]["to"]; */

  foreach(sort(indices(for_mapping[which_id]["re"])), int vote_id)
    {
      if (total_vot>0)
	intpercent=((int)(100*((float)(((for_mapping[which_id]["re"])[vote_id])["vot"]))/total_vot));
      else
	intpercent=0;
      res+="<tr>"
	"<td >"+(((for_mapping[which_id]["re"])[vote_id])["txt"])+"</td>"
	"<td width=330>";
      if (temp[vote_id]>0) {
	res+="<img height=9 src=\""+(query("base_url")+LEFTGIF)+"\">"
	  "<img height=9 width=\""+(3*intpercent)+"\" src=\""+(query("base_url")+MIDDLEGIF)+"\">"
	  "<img height=9 src=\""+(query("base_url")+RIGHTGIF)+"\">";
      }
      else
	res+="<font size=-2 face=arial,helvetica><i>No votes yet</i></font>";
      res+="</td><td>"+temp[vote_id]+" votes = "+intpercent+"%</td>"
	"</tr>";
    }

  res+="<tr><td colspan=3 align=right><font size=-1>"
    "Total number of votes: <b>"+for_mapping[which_id]["to"]+"</b><hr noshade>\n"
    "This question is based on a suggestion sent to us by "+for_mapping[which_id]["by"]+"<br>\n"
    "Poll started at "+ctime(for_mapping[which_id]["ST"])+", ";
  if (for_mapping[which_id]["EN"])
    res+="Poll ends at "+ctime(for_mapping[which_id]["EN"])+"\n";
  res+="</font><br>"+CNOT+"</td></tr>"
    "</table>";

  return res;
}

void savedays(int nomber)
{
  re_usable_file_object->open((query("full_search_path")+"poll_days.dat"), "wtc");
  re_usable_file_object->write((string)nomber);
  re_usable_file_object->close();
  daycache = nomber;
}

int loaddays()
{
  if(daycache) return daycache;
  return (daycache = (int)(read_bytes((query("full_search_path")+"poll_days.dat"))||((string)(SWPTIME))));
}


void real_save_poll(mapping save_this_one, int which_one)
{
  mapping one;
  int singlemax;
  re_usable_file_object->open(filedbnames(which_one), "wtc");
  foreach(indices(save_this_one), int voteid)
    {
      one = save_this_one[voteid];
      singlemax = sizeof(indices(one["re"]));
      re_usable_file_object->write(voteid+"|"+one["ok"]+"|"+one["SU"]+"|"+one["ST"]+"|"+one["EN"]+"|"
				   ""+one["to"]+"|"+one["by"]+"|"+one["em"]+"|"+one["qu"]+"|");
      for (int j=0; j<singlemax; j++)
	re_usable_file_object->write(one["re"][j]["txt"]+"@"+one["re"][j]["vot"]+((j!=(singlemax-1))?"#":"\n"));
    }
  re_usable_file_object->close();
}

void save_poll(int which_one)
{
  switch (which_one) {
  case HISTORY : real_save_poll(history_polls, which_one); break;
  case CURRENT : real_save_poll(current_poll, which_one); break;
  case SUGGESTED : real_save_poll(suggested_polls, which_one); break;
  }
}

void rotate_schedule()
{
  /* Moves the current poll to the history.  Then it Picks the
     suggested poll with the highest rating above zero and assign the
     current_poll */

  if(sizeof(suggested_polls)>0) /* If we can find a new scheudle to roll in. */
    {
      int *weights=({});
      int *ids=({});
      foreach(indices(suggested_polls), int voteid)
	{
	  ids+=({ voteid });
	  weights+= ({ suggested_polls[voteid]["ok"] });
	}
      sort(weights,ids);
      int pickedid=ids[sizeof(ids)-1];
      if (suggested_polls[pickedid]["ok"]>0)
	{
	  if (running_poll_id) /* Do we have anything currently running? */
	    {
	      history_polls[running_poll_id] = current_poll[running_poll_id]; /* move to history */
	      history_polls[running_poll_id]["EN"]=time(); /* This poll ended NOW */
	    }

	  current_poll = ([ pickedid : suggested_polls[pickedid] ]); /* Assign a new current! */
 	  current_poll[pickedid]["ST"]=time(); /* The start date is NOW */
	  current_poll[pickedid]["EN"]=(time()+(60*60*24*loaddays())); /* Assign an end date of poll */
	  running_poll_id = pickedid;

	  m_delete(suggested_polls, pickedid);

	  save_poll(HISTORY);
	  save_poll(CURRENT);
	  save_poll(SUGGESTED);
	  started = 0; /* Force a restart */
	  write_file((query("full_search_path")+"log.txt"), 
		     "Schedule rotated. Got a new poll now, id="+running_poll_id+".\n");
	}
    }

}


string fixx(string what)
{
  /* Just zap some dangerous delimeters */
  return replace(replace(replace(what, "#", " "), "@", " "), "|", " ");
}

mapping process_poll(string raw_data)
{
  int id;
  mapping building_up = ([]);
  if (raw_data)
    {
      foreach(raw_data/"\n", string raw_row)
	{
	  string *splitted_raw_row = raw_row/"|";
	  if (sizeof(splitted_raw_row)>1)
	    {
	      id=0;
	      mapping map_tmp_result = ([]);
	      foreach(splitted_raw_row[9]/"#", string tmp_result)
		map_tmp_result += ([ (id++) :
				   ([ "txt" : (string)((tmp_result/"@")[0]||""), 
				    "vot" : ((int)(tmp_result/"@")[1]) ]) ]);

	      building_up += ([((int)splitted_raw_row[0]): ([
							     "ok" : (int)(splitted_raw_row[1]), /* status for it*/
							     "SU" : (int)(splitted_raw_row[2]), /* suggested at */
							     "ST" : (int)(splitted_raw_row[3]), /* put on air */
							     "EN" : (int)(splitted_raw_row[4]), /* put off air */
							     "to": (int)(splitted_raw_row[5]), /* total no of votes achieved so far! */
							     "by" : (splitted_raw_row[6]||"No Email?"),
							     "em" : (splitted_raw_row[7]||"No Email?"),
							     "qu" : (splitted_raw_row[8]),
							     "re" : map_tmp_result
	      ]) ]);
	    }
	}
      return building_up;
    }
  else
    return ([]);
}


void load_all_polls()
{
  // Load history, Load suggested, Load current.
  for (int which_one=0; which_one<3; which_one++)
    {
      switch (which_one) {
      case SUGGESTED : suggested_polls = process_poll(read_bytes(filedbnames(which_one))); break;
      case CURRENT : {
	current_poll = process_poll(read_bytes(filedbnames(which_one))); 
	if (sizeof(current_poll)>0)
	  running_poll_id = (int)(indices(current_poll)[0]);
	else
	  running_poll_id=0;
	break;
      }
      case HISTORY : history_polls = process_poll(read_bytes(filedbnames(which_one))); break;
      default :
	break;
      }
    }
} 

string tag_poll(string tag_name, mapping arguments, object req_id, object file, mapping defines)
{
  string res="";
  int viewhistoryfor=0,admin_password_ok=0;

  if (!(started)) {     load_all_polls(); started=1;   }

  switch (req_id["variables"]["action"]) {
  case "vote" : 
    /* Do the actual voting here */
    {
      int voteforid = ((int)(req_id["variables"]["vote"]));
      if (search(indices(current_poll[running_poll_id]["re"]), (int)(req_id["variables"]["vote"]))!=-1)
	{
	  if (!(voted_today[req_id->remoteaddr]))
	    {
	      res += "<b>Thanks for your vote, dear user from "+(roxen->quick_ip_to_host(req_id->remoteaddr))+". Your vote "
		"for \"<b>"+(((current_poll[running_poll_id]["re"])[voteforid])["txt"])+"</b>\" has been registered!";
	      voted_today[req_id->remoteaddr]=time();
	      current_poll[running_poll_id]["to"]+=1;
	      ((current_poll[running_poll_id]["re"])[voteforid])["vot"]++;
	      save_poll(CURRENT);
	      write_file((query("full_search_path")+"log.txt"), 
			 "Got vote from ["+(roxen->quick_ip_to_host(req_id->remoteaddr))+"] "
			 "for ["+(((current_poll[running_poll_id]["re"])[voteforid])["txt"])+"]\n");
	    }
	  //	  else
	  {
	    // res += "We're sorry, but someone (probably you) have already "
	    // "voted from your host at "+ctime(voted_today[req_id->remoteaddr])+". To avoid cheating, we don't allow the same "
	    // "person to vote twice. We're sorry for the inconvenience.";
	  }
	}
      else
	{
	}
    }
    break;
  case "suggest" : /* We got a new user suggestion sumitted to us */
    {
      /* Let's check the validity of the submitted new vote, ok? */
      string error="";
      string email = req_id["variables"]["em"]||"";
      string name = req_id["variables"]["na"]||"";
      string question = req_id["variables"]["qu"]||"";
      string *votes = ({});

      foreach(indices(suggested_polls), string voteid)
	if (suggested_polls[voteid]["qu"]==question)
	  error+="There's already a question about this (Did you reload this page? "
	    "You shouldn't do that, you know...)";
      if (question=="")
	error+="Please, you must write a QUESTION! Please go back and fix this!<p>";
      else
	if ((sizeof(question)<6) || (sizeof(question)>90))
	  error+="The question you submitted (\""+question+"\") is not correct. "
	    "Either its too long and complex, or too short and simple. "
	    "Please keep within six to 90 characters!<p>";
      if (email=="")
	error+="You must give us your email address! please go back and fix this!<p>";
      else
	if ((sizeof(email)<3) || (search(email, "@")==-1))
	  error+="The email adress you submitted (\""+email+"\") is not correct. "
	    "Please fix this!<p>";
      if (name=="")
	error+="You must give us your name! please go back and fix this!<p>";
      else
	if ((sizeof(name)<3) || (sizeof(name)>30))
	  error+="The name adress you gave us (\""+email+"\") is either too long or short. "
	    "Please fix this!<p>";
      for (int i=0; i<(query("no_options")); i++)
	if ((req_id["variables"][(string)i]||"")!="")
	  votes += ({ req_id["variables"][(string)i] });
      if (sizeof(votes)==0)
	error += "You must enter some vote alternatives!";
      else
	if (sizeof(votes)<2)
	  error += "You must enter atleast two vote alternatives!";
      foreach(votes, string vote)
	if (sizeof(vote)>60)
	  error += "The vote alternative \""+vote+"\" has too many characters in it. "
	    "It's simply too long.";
      if (error!="")
	return "<b>We experienced some problems with your new vote "
	  "topic suggestion:</b><p>"+error+"<p>"
	  "Please go back and fix these problem(s)!";
      else
	{
	  /* Everything okay! */
	  mapping newone = ([]);
	  mapping newone2 = ([]);
	  newone["SU"]=time(); /* time suggested */
	  newone["ST"]=0;
	  newone["EN"]=0;
	  newone["ST"]=0;
	  newone["to"]=0; /* no votes for starters */
	  newone["by"]=fixx(name);
	  newone["ok"]=0;
	  newone["em"]=email;
	  newone["qu"]=fixx(question);

	  for (int j=0; j<sizeof(votes); j++)
	    newone2[j]=([ "vot":0,
			"txt" : fixx(votes[j]) ]);

	  newone["re"]= newone2;
	  suggested_polls[time()]=newone;	  
	  save_poll(SUGGESTED);

	  return "<b>Thank you for your new vote topic suggestion!</b><p>"
	    "It has been send to the administrators, who will decide when to "
	    "add it (if ever).<br>If your topic is selected, you will recieve "
	    "an email the day the vote goes public!<p>"
	    "<a href=\""+(query("base_url")+"results.html?uniq="+time()+"")+"\">"
	    "Click here to go back to the vote result page</a>.";
	}
    }
    break;
  case "submit_pass" :
    if ((req_id["variables"]["password"])==(query("adminpassword")))
      admin_password_ok=1;
    else
      admin_password_ok=0;
    break;
  case "submit_id" :
    viewhistoryfor = ((int)(req_id["variables"]["vote"]));
    break;
  default :
    //    res += sprintf("You encountered an error. Send bugreport to the web master. The variables = %O<p>", req_id["variables"]);
    break;
  }

  switch (arguments->cmd) {
  case "current" : 
    /* First lets check so its not out dated, ok */
    if (!running_poll_id) 
      rotate_schedule();
    else
      if (current_poll[running_poll_id]["EN"]<time())
	rotate_schedule();

    res+=(prehtml());
    
    if (running_poll_id)
      {
	res+= "<font color=\""+(query("3_color"))+"\">"
	  "<center>"+current_poll[running_poll_id]["qu"]+"</center></font>"
	  "<form action=\""+(query("base_url")+"results.html?uniq="+time()+"")+"\" "
	  "method=GET><input type=hidden name=action value=vote>";

	foreach(sort(indices(current_poll[running_poll_id]["re"])), int vote_id)
	  res+="<input type=radio name=vote value=\""+vote_id+"\">"
	  "<font size=-1 color=\""+(query("3_color"))+"\""
	  ">"+(((current_poll[running_poll_id]["re"])[vote_id])["txt"])+"</font><br>";

	res+="<p><center><input type=hidden name=at value=\""+time()+"\">"
	  "<font size=2 face=arial,helvetica>"
	  "<input type=submit value=\"Submit vote!\"></font></form>"
	  "</font></center>";
      }
    else
      res+="No running poll!";
  
    res+=(posthtml());

    break;
  case "admin" :
    if (!admin_password_ok)
      {
	return "Enter your administrator password, please:"
	  "<form action=\""+(query("base_url")+"admin.html?uniq="+time()+"")+"\" method=GET>\n"
	  "<input type=hidden name=action value=submit_pass>"
	  "<input type=hidden name=uniq value="+time()+"><input name=password> &nbsp; "
	  "<input type=submit value=\"Continue!\"></form>";
      } 
    else
      {
	switch(req_id["variables"]["subaction"]) {
	case "rotate_now" :
	  if (lastavoid == ((int)req_id["variables"]["avoiddoublereload"]))
	    {
	      res+="Error, you tried to reload the page and do a double shift."
		"I just stopped you in doing that. Congratulations! :-)";
	    }
	  else
	    {
	      rotate_schedule();
	      lastavoid = ((int)req_id["variables"]["avoiddoublereload"]);
	    }

	  break;
	case "save_days" :
	  savedays((int)((req_id["variables"]["days"])||(SWPTIME)));
	  break;
	case "fix_schedule" :
	  foreach(indices(req_id["variables"]), string varib)
	    if (sizeof(varib)>7)
	      if (varib[0..6]=="weight_")
		{
		  if (suggested_polls[((int)varib[7..99])])
		    {
		      int new_score = ((int)req_id["variables"][varib]);
		      int polid = ((int)varib[7..99]);
		      if (new_score<0)
			m_delete(suggested_polls, polid);
		      else
			suggested_polls[polid]["ok"]=new_score;
		    }
		}
	  save_poll(SUGGESTED);
	  break;
	}

	res+="<h3>Administrator mode.</h3>"
	  "<hr>"
	  "<form action=\""+(query("base_url")+"admin.html?uniq="+time()+"")+"\" method=GET>\n"
	  "<input type=hidden name=password value=\""+(query("adminpassword"))+"\">"
	  "<input type=hidden name=action value=submit_pass>"
	  "<input type=hidden name=subaction value=save_days>"
	  "By default, run the polls for: <input size=4 "
	  "value=\""+(loaddays())+"\" name=days> days.&nbsp;"
	  "<input type=submit value=\"Save!\">"
	  "</form><p>";

	res+="<table border=1><tr><td><b><u>Current Poll!</u>:</b><p>";
	if (running_poll_id)
	  {
	    res+=do_neat_table(current_poll, running_poll_id);
	    res+="<br>"
	      "This one was suggested by <b>"+current_poll[running_poll_id]["by"]+"</b> "
	      "("+current_poll[running_poll_id]["em"]+")"
	      " at "+ctime(current_poll[running_poll_id]["SU"])+".<br> It has been "
	      "running since "
	      ""+ctime(current_poll[running_poll_id]["ST"])+" =  "
	      " "+((time()-(current_poll[running_poll_id]["ST"]))/60/60)+" hours, "
	      "and will run for another "
	      " "+((current_poll[running_poll_id]["EN"]-time())/60/60)+" hours since "
	      "it was originally suggested that this poll closes "
	      "at "+ctime(current_poll[running_poll_id]["EN"])+" Note "
	      "that the end date for the poll was calculated at rotation "
	      "time and held statically; it will not be recalculated if "
	      "you change the days option.";
	  }
	else
	  res+="There's no poll running right now.";

	res+="<form action=\""+(query("base_url")+"admin.html?uniq="+time()+"")+"\" method=GET>\n"
	  "<input type=hidden name=subaction value=rotate_now>"
	  "<input type=hidden name=avoiddoublereload value=\""+time()+"\">"
	  "<input type=hidden name=password value=\""+(query("adminpassword"))+"\">"
	  "<input type=hidden name=action value=submit_pass>";
	"<input type=hidden name=uniq value="+time()+">";

	if (running_poll_id)
	  res+="<input type=submit value=\"Force this poll to close NOW; "
	    "and go on to the next in the schedule!\">";
	else
	  {
	    if (sizeof(suggested_polls)>0)
	      res+="<input type=submit value=\"Roll in the highest "
		"ranked suggestion and activate it right away!!\">";
	  }
	res+="</form>"
	  "</td></tr></table>\n";

	res+="<br><table border=1><tr><td><b><u>Suggested polls</u>:</b><p>";
	res+="<form action=\""+(query("base_url")+"admin.html?uniq="+time()+"")+"\" method=GET>\n"
	  "<input type=hidden name=subaction value=fix_schedule>"
	  "<input type=hidden name=password value=\""+(query("adminpassword"))+"\">"
	  "<input type=hidden name=action value=submit_pass>";

	int weightsum=0;
	res+="<table border=1>";

	int *sorttmp_we=({});
	string *sorttmp_id=({});

	foreach(indices(suggested_polls), string voteid) /* Build two tables */
	  {
	    sorttmp_id+=({voteid});
	    sorttmp_we+=({-suggested_polls[voteid]["ok"]});
	  }

	sort(sorttmp_we, sorttmp_id); /* Sort the id's as a weight side-effect */

	foreach(sorttmp_id, string voteid)
	  {
	    if (suggested_polls[voteid])
	      {
		weightsum += suggested_polls[voteid]["ok"];
		res+="<tr>"
		  "<td rowspan=2 valign=center>Weight: <input size=2 "
		  "name=weight_"+voteid+" value=\""+suggested_polls[voteid]["ok"]+"\"></td>"	
		  "<td><b>"+suggested_polls[voteid]["qu"]+"</b></td>"
		  "<td>";
		foreach(sort(indices(suggested_polls[voteid]["re"])), int vote_id)
		  res+=" ["+(((suggested_polls[voteid]["re"])[vote_id])["txt"])+"] ";
	      
		res+="</td>"
		  "<tr><td>By: "+suggested_polls[voteid]["by"]+" ("+suggested_polls[voteid]["em"]+")</td>"
		  "<td>Suggested at "+ctime(suggested_polls[voteid]["SU"])+"</td>"
		  "</tr>";
	      }
	  }
	if ((weightsum==0))
	  if (sizeof(indices(suggested_polls))>0)
	    res+= "<tr><td colspan=3><font color=red><b>Warning: "
	      "There are no polls right now that has a weight above zero!</td></tr>";
	  else
	    res+= "<tr><td colspan=3><font color=red><b>Warning: "
	      "There are no polls in the schedule right now!</td></tr>";

	if (sizeof(indices(suggested_polls))>0)
	  res+= "<tr><td colspan=3><input type=submit value=\"Save weights!\"></form></td></tr>";

	res+="<tr><td colspan=3>Some weight instructions:<ul><li><b>Positive values:</b>"
	  "A new poll question is automatically moved in once the vote time has passed."
	  "The suggested poll with the <i>heighest</i> weight (above zero) is then selected."
	  "If several questions share the same weight, one is chosen out of random."
	  "<li><b>Zero values</b>: The default value for new questions is weight zero (0)."
	  "These are never picked and are just on hold.<li>"
	  "<b>Negative values</b>: If you enter a negative value (-1) the question "
	  "is deleted when you press the save button.</ul>";
	res+="</table>";
	res+="</form>"
	  "</td></tr></table>\n";

	res+="<br><table border=1><tr><td><b><u>Historical polls</u>:</b><p>";
	if (sizeof(indices(history_polls))>0)
	  {
	    foreach(indices(history_polls), string voteid)
	      res+="<tr><td>\""+history_polls[voteid]["qu"]+"\" ended at "+ctime(history_polls[voteid]["EN"])+"</td></tr>";
	  }
	else
	  res+="No polls have yet gone to history!";
	res+="</table>";

	return res;
      }
    break;
  case "viewhistory" :
    if (viewhistoryfor)
      {
	if (search(indices(history_polls), viewhistoryfor)!=-1)
	  {
	    res+="\n<!-- ancient poll results -->\n";
	    res+= "<h2>Results for an old poll.</h2>";
	    res+= do_neat_table(history_polls, viewhistoryfor);
	    res+="\n<!-- end of the ancient, well, almost,  poll results -->\n";
	  }
      }
    break;
  case "results" :
    {
      res+="\n<!-- the current user poll results -->\n"
	"<h2>Results for the currently running poll.</h2>";
      if (running_poll_id) 
	res+=do_neat_table(current_poll, running_poll_id)+"\n";
      else
	res+="There is no running poll right now.";
      res+="<!-- end of the current user poll results -->\n";
    }
    break;
  case "history" :
    res+="\n<!-- the list of all old user polls -->\n<ul>";
    foreach(indices(history_polls), int voteid)
      res+="<li><a href=\""+(query("base_url")+"history.html?uniq="+time()+"")+"?action=submit_id&"
      "vote="+voteid+"\">"+history_polls[voteid]["qu"]+"</a></li>\n";
    res+="</ul>\n<!-- end of the list of all old user polls -->\n";
    break;
  case "suggest" :
    res+="\n<!-- Suggest a new topic to vote for -->\n"
      "<table border=1><tr><td ><b>To suggest a new vote topic, "
      "Please fill out this form:</b><p>Once submitted to us, you cannot "
      "change it, so please take your time and do this carefully.<br>Check "
      "for errors and typos before you press that submit button.<p>"
      "<font size=-1><i>Note: You don't need to fill out all the available "
      "options, but the minimum is (of course) two!</i></font><br></td></tr>"
      "<tr><td><form action=\""+(query("base_url")+"suggest.html?uniq="+time()+"")+"\">";
    res+=""
      "<input type=hidden name=\"action\" value=\"suggest\">"
      "<tr><td>Your name: <input type=hidden name=uniq value="+time()+">"
      "<input name=\"na\" size=40></td></tr>"
      "<tr><td>Your email: <input name=\"em\" size=40></td></tr>"
      "<tr><td>The question:<input name=\"qu\" size=60></td></tr>";
    for (int i=0; i<(query("no_options")); i++)
      res+="<tr><td> Option #"+(1+i)+" : <input size=20 "
	"name=\""+i+"\">"+((i>1)?"(Optional)":"")+"</td></tr>\n"; 
    res+="<tr><td align=right><input type=submit "
      "value=\"Click here to submit this suggestion!\"></td></tr>"
      "</form></table>"+CNOT+"<br>"
      "\n<!-- the list of all old user polls -->\n";
    break;
  default :
    res+= "OKay<p>";
    foreach(indices(req_id), string idd)
      res += "<b>"+idd+"</b> : "+sprintf("%O", req_id[idd])+"<hr>";
    break;
  }
  return res;
}


array register_module()
{
  return ({ MODULE_PARSER,
	      "User poll module (RoxPoll "+VER+")",
	      ("RoxPoll "+VER+" allows the users of your site to vote at polls,"
	       "suggest new poll questions. It also contains a simple administrators "
	       "interface and enough automated behaviour to be easy to use for any "
	       "stressed web master. (C)1998 Thomas abrahamsson, thomas@abrahamsson.org"),
	      0, 
	      1,	// Allow only a copy per server.
	      });
}

mapping query_tag_callers() { return ([
				       "poll":tag_poll, 
				       ]); }
 
