/****************************************************************************

 Copyright (C) 2002-2007 Gilles Debunne (Gilles.Debunne@imag.fr)

 This file is part of the QGLViewer library.
 Version 2.2.6-3, released on August 28, 2007.

 http://artis.imag.fr/Members/Gilles.Debunne/QGLViewer

 libQGLViewer is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 libQGLViewer is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with libQGLViewer; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*****************************************************************************/

#ifndef GLVIEW_H
#define GLVIEW_H

#include <qgl.h>
#include <QGLViewer/qglviewer.h>
#include <iostream>
#include "jeu.h"
#include "piece.h"

/*
 * Classe generique pour les fenetres OpenGl
 */
class GLView : public QGLViewer
{
  Q_OBJECT
public:
  GLView(QWidget* parent) : QGLViewer(parent) {}

  virtual void init();
  virtual void setPieces(SetOfPiece *sop) { setofpiece=sop; };

signals:
  void update();

protected:
  virtual void select(const QMouseEvent* e);
  virtual void drawWithId() {};
  virtual void applySelection(int) {};
  virtual void keyPressEvent(QKeyEvent *) {};

  SetOfPiece *setofpiece;

private:
  GLuint texture_bois;
};



// Classe fille pour la vue des pieces a selectionner
class GLViewPieces : public GLView
{
  Q_OBJECT
public:
  GLViewPieces(QWidget* parent) : GLView(parent) {}

protected:
  virtual void draw();
  virtual void init();

  virtual void drawWithId() { draw(); };
  virtual void applySelection(int);

signals:
  void changeJoueur();
};



// Classe fille pour la vue du plateau de jeu
class GLViewJeu : public GLView
{
  Q_OBJECT

public:
  GLViewJeu(QWidget* parent) : GLView(parent) {}
  ~GLViewJeu() { glDeleteLists(plateau, 1); }

  void reset() { jeu.init(); }

protected :
  virtual void draw();
  virtual void init();

  virtual void drawWithId();
  virtual void applySelection(int);

signals:
  void piecePlacee();
  void endGame();

private:
  GLuint plateau;
  Jeu jeu;

  void makePlateau();
};

#endif // GLVIEW_H
