/* ptypeProgress.t.cc
 */

#include "osl/progress/ptypeProgress.h"
#include "osl/apply_move/applyMove.h"
#include "osl/state/numEffectState.h"
#include "osl/record/csaRecord.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
#include <fstream>

class PtypeProgressTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PtypeProgressTest);
  CPPUNIT_TEST(testConsistent);
  CPPUNIT_TEST_SUITE_END();
public:
  void testConsistent();
};

CPPUNIT_TEST_SUITE_REGISTRATION(PtypeProgressTest);

using namespace osl;
using namespace osl::progress;

void PtypeProgressTest::testConsistent()
{
  extern bool isShortTest;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  int max=100;
  if (isShortTest)
      max=10;
  std::string filename;
  int i=0;
  while((ifs >> filename) && (++i<max)) 
  {
    if (! isShortTest)
      std::cerr << filename << " ";
    std::string full_filename = OslConfig::testCsaFile(filename);

    Record rec=CsaFile(full_filename).getRecord();
    NumEffectState state(rec.getInitialState());
    const vector<osl::Move> moves=rec.getMoves();
    PtypeProgress incremental(state);
    for (size_t i=0; i<moves.size(); ++i)
    {
      ApplyMoveOfTurn::doMove(state, moves[i]);
      incremental.update(state, moves[i]);
      const PtypeProgress batch(state);
      CPPUNIT_ASSERT_EQUAL(incremental, batch);
    }
  }
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
