#include "osl/misc/mask.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
extern bool isShortTest;

class maskTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( maskTest );
  CPPUNIT_TEST( testBsf );
  CPPUNIT_TEST( testGetOne );
  CPPUNIT_TEST( testHasMultipleBit );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testBsf();
  void testGetOne();
  void testHasMultipleBit();
};


CPPUNIT_TEST_SUITE_REGISTRATION(maskTest);

void maskTest::testBsf(){
  CPPUNIT_ASSERT_EQUAL(2,mask_t::makeDirect(0x4).bsf());
  CPPUNIT_ASSERT_EQUAL(2,mask_t::makeDirect(0xc).bsf());
#if OSL_WORDSIZE == 64
  CPPUNIT_ASSERT_EQUAL(33,mask_t::makeDirect(0x200000000uLL).bsf());
#endif
}

void maskTest::testGetOne(){
  {
    mask_t mask=mask_t::makeDirect(0x44442222);
    int num=mask.takeOneBit();
    CPPUNIT_ASSERT_EQUAL(num,1);
    CPPUNIT_ASSERT_EQUAL(mask_t::makeDirect(0x44442220),mask);
  }
}

void maskTest::testHasMultipleBit(){
  CPPUNIT_ASSERT(mask_t::makeDirect(0x40000040).hasMultipleBit());
  //  CPPUNIT_ASSERT(!hasMultipleBit((mask_t)((mask_int_t)0)));
  CPPUNIT_ASSERT(! mask_t::makeDirect(0x8000000).hasMultipleBit());
}
