/* see.t.cc
 */
#include "osl/eval/see.h"
#include "osl/eval/pieceEval.h"
#include "osl/state/numEffectState.h"
#include "osl/record/csaString.h"
#include "osl/effect_util/pin.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
#include <fstream>

class SeeTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SeeTest);
  CPPUNIT_TEST(testSee);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSee();
};

CPPUNIT_TEST_SUITE_REGISTRATION(SeeTest);

using namespace osl;
using namespace osl::eval;
extern bool isShortTest;

const int Gold = PtypeEvalTraits<GOLD>::val;
const int Silver = PtypeEvalTraits<SILVER>::val;
const int Rook = PtypeEvalTraits<ROOK>::val;
const int Knight = PtypeEvalTraits<KNIGHT>::val;
const int Pawn = PtypeEvalTraits<PAWN>::val;
const int Pknight = PtypeEvalTraits<PKNIGHT>::val;
const int Bishop = PtypeEvalTraits<BISHOP>::val;
const int Pbishop = PtypeEvalTraits<PBISHOP>::val;

void SeeTest::testSee()
{
  const NumEffectState state(CsaString(
			       "P1-KY-KE-GI-KI *  * -HI-KE * \n"
			       "P2 * -HI *  * -KA-OU *  *  * \n"
			       "P3-FU * -FU-FU-FU * -GI-FU-KY\n"
			       "P4 * +KE *  *  * -FU *  * -FU\n"
			       "P5 * -FU+KE+KA *  *  *  * +FU\n"
			       "P6 *  * +FU *  *  * +FU *  * \n"
			       "P7+FU+FU * +FU+FU+FU *  *  * \n"
			       "P8 * +GI+KI *  *  * +GI *  * \n"
			       "P9+KY *  *  * +OU+KI *  * +KY\n"
			       "P+00FU\n"
			       "P+00FU\n"
			       "P+00KI\n"
			       "+\n").getInitialState());
  {
    int ret=See::see
      (state, Move(Position(1,5),Position(1,4),PAWN,PAWN,false,BLACK));
    /** 相手が取り替えさないのが最善 */
    CPPUNIT_ASSERT_EQUAL(+Pawn*2, ret);
  }
  {
    int ret=See::see
      (state, Move(Position(6,5),Position(9,2),PBISHOP,PTYPE_EMPTY,true,BLACK));
    /** 香車取り返し only */
    CPPUNIT_ASSERT_EQUAL(-Bishop*2, ret);
  }
  {
    int ret=See::see
      (state, Move(Position(6,5),Position(8,3),PBISHOP,PTYPE_EMPTY,true,BLACK));
    /** 成り得 */
    CPPUNIT_ASSERT_EQUAL(+Pbishop-Bishop, ret);
  }
  {
    int ret=See::see
      (state, Move(Position(6,5),Position(2,1),PBISHOP,KNIGHT,true,BLACK));
    CPPUNIT_ASSERT_EQUAL(+Knight*2-Bishop*2, ret);
  }
  {
    int ret=See::see
      (state, Move(Position(8,4),Position(7,2),PKNIGHT,PTYPE_EMPTY,true,BLACK));
    CPPUNIT_ASSERT_EQUAL(-Knight*2, ret);
  }
  {
    int ret1=See::see
      (state, Move(Position(6,5),Position(5,4),BISHOP,PTYPE_EMPTY,false,BLACK));
    CPPUNIT_ASSERT_EQUAL(-Bishop*2, ret1);
  }
  
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE * -KI *  *  * -KE-KY\n"
				 "P2 * -OU-GI * -KI * -HI *  * \n"
				 "P3 * -FU *  * -FU-GI-KA * -FU\n"
				 "P4 *  * -FU-FU * -FU-FU-FU * \n"
				 "P5-FU *  *  *  *  *  *  *  * \n"
				 "P6 *  * +FU * +FU+GI+FU * +FU\n"
				 "P7 * +FU * +FU * +FU *  *  * \n"
				 "P8 * +KA+OU * +KI+GI * +HI * \n"
				 "P9+KY+KE * +KI *  *  * +KE+KY\n"
				 "P-00FU00FU\n"
				 "+\n").getInitialState());
    int ret=See::see(state, Move(Position(5,6),Position(5,5),PAWN,PTYPE_EMPTY,false,BLACK));
    CPPUNIT_ASSERT_EQUAL(0, ret);
  }
  {
    CPPUNIT_ASSERT_EQUAL(0, Ptype_Eval_Table.value(PTYPE_EMPTY));
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  * +RY-KI-OU *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+OU *  *  *  *  *  *  *  * \n"
			   "P+00KI\n"
			   "P-00AL\n"
			   "+\n").getInitialState());
    {
      Move m = Move(Position(6,3),GOLD,BLACK);
      const int ret = See::see(state, m, PieceMask(), 
			       effect_util::Pin::make(state, WHITE));
      // 相手は取れない
      CPPUNIT_ASSERT_EQUAL(0, ret);
    }
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI-KI *  * -HI-KE * \n"
			   "P2 * -HI *  * -KA-OU *  *  * \n"
			   "P3-FU * -FU-FU-FU * -GI-FU-KY\n"
			   "P4 * +KE *  *  * -FU *  * -FU\n"
			   "P5 * -FU+KE+KA *  *  *  * +FU\n"
			   "P6 *  * +FU *  *  * +FU *  * \n"
			   "P7+FU+FU * +FU+FU+FU *  *  * \n"
			   "P8 * +GI+KI *  *  * +GI *  * \n"
			   "P9+KY *  *  * +OU+KI *  * +KY\n"
			   "P+00FU\n"
			   "P+00FU\n"
			   "P+00KI\n"
			   "+\n").getInitialState());
    {
      Move m = Move(Position(1,5),Position(1,4),PAWN,PAWN,false,BLACK);
      const int ret = See::see(state, m);
      // 相手が取り替えさないのが最善
      CPPUNIT_ASSERT_EQUAL(Pawn*2, ret);
    }
    {
      Move m = Move(Position(8,4),Position(7,2),PKNIGHT,PTYPE_EMPTY,true,BLACK);
      const int ret = See::see(state, m);
      // ただ捨て
      CPPUNIT_ASSERT_EQUAL(-Knight*2, ret);
    }
    state.changeTurn();
    {
      Move m = Move(Position(8,5),Position(8,6),PAWN,PTYPE_EMPTY,false,WHITE);
      const int ret = See::see(state, m);
      // ただ捨て
      CPPUNIT_ASSERT_EQUAL(-Pawn*2, ret);
    }
    {
      Move m = Move(Position(8,2),Position(8,4),ROOK,KNIGHT,false,WHITE);
      const int ret = See::see(state, m);
      // ただ取り
      CPPUNIT_ASSERT_EQUAL(Knight*2, ret);
    }
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  * -HI-KE-KY\n"
			   "P2 *  *  * +RY+UM-GI-KI-OU * \n"
			   "P3+TO *  *  * -FU * -GI *  * \n"
			   "P4-FU *  * -FU * -GI+KY-FU * \n"
			   "P5 * -FU+FU-KI * -FU-FU *  * \n"
			   "P6+FU+FU *  * +KY * +FU * -FU\n"
			   "P7 *  *  *  * +FU+FU * +FU * \n"
			   "P8 *  *  *  * +KI * +GI+OU+FU\n"
			   "P9 *  *  *  *  * +KI * +KE+KY\n"
			   "P-00FU\n"
			   "P-00KE\n"
			   "P-00KE\n"
			   "P+00KA\n"
			   "-\n").getInitialState());
    {
      const Position p86 = Position(8,6);
      Move m = Move(Position(8,5),p86,PAWN,PAWN,false,WHITE);
      const int ret = See::see(state, m);
      CPPUNIT_ASSERT_EQUAL(Pawn*2, ret);

    }
    {
      const Position p36 = Position(3,6);
      Move m = Move(Position(3,5),p36,PAWN,PAWN,false,WHITE);
      const int ret = See::see(state, m);
      // ただ取りなので得するはず
      CPPUNIT_ASSERT_EQUAL(Pawn*2, ret);
    }
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  * -KI-OU-KE-KY\n"
			   "P2 *  *  *  * -KI * -GI *  * \n"
			   "P3 *  *  *  * -FU+FU * -FU-FU\n"
			   "P4 *  *  *  *  *  * +GI *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  * +HI *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 * +OU *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "+\n").getInitialState());
    // 追加効き
    Move m = Move(Position(3,3),SILVER,BLACK);
    const int ret = See::see(state, m);
    CPPUNIT_ASSERT(ret > -Silver*2);
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  * -OU\n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  * +FU\n"
			   "P7 *  *  *  *  * +FU+FU+FU * \n"
			   "P8 *  *  *  *  * -GI+GI+OU * \n"
			   "P9 *  * -RY *  * +KI * +KE+KY\n"
			   "P-00AL\n"
			   "-\n").getInitialState());
    // 影効き
    Move m = Move(Position(3,9),BISHOP,WHITE);
    const int ret = See::see(state, m);
    CPPUNIT_ASSERT(ret > -Bishop*2);
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
