#ifndef _KISEN_H
#define _KISEN_H

#include "osl/record/record.h"
#include "osl/state/numEffectState.h"
#include "osl/misc/carray.h"
#include <string>
#include <iosfwd>
#include <fstream>
namespace osl
{
  namespace record
  {
    class KisenUtils{
    public:
      static Position convertPosition( int pos );
      static Move convertMove(state::SimpleState const& state,int c0,int c1 );
      static int convertPosition(Position pos);
    };

    class IKisenStream : public IRecordStream{
    private:
      CArray<unsigned char, 512> cbuf;
      state::SimpleState state;
      RecordVisitor rv;
    public:
      IKisenStream(char const readbuf[]) : state(HIRATE) {
	std::copy(&readbuf[0],&readbuf[512],&cbuf[0]);
      }
      state::SimpleState getState() const { return state;}
      virtual void load(Record*);
      virtual ~IKisenStream(){};
    };
    /**
     * 「.kif」という拡張子を持つ棋泉形式ファイル.
     * 手のみの情報が入っている
     */
    class KisenFile{
    private:
      std::ifstream ifs;
      size_t numberOfGames;
      state::SimpleState const initialState;
      const std::string fileName;
    public:
      static const size_t maxMoves=256;
      explicit KisenFile(const std::string& fileName);
      ~KisenFile();

      size_t size() const{ return numberOfGames; }
      const NumEffectState getInitialState() const{ return NumEffectState(initialState); }
      const vector<Move> getMoves(size_t index);
      const std::string& getFileName() const { return fileName; }
      const std::string ipxFileName() const { return ipxFileName(fileName); }
      static const std::string ipxFileName(const std::string&);
    };
    /**
     * 「.ipx」という拡張子を持つ棋泉形式ファイル.
     * 対局者に関する情報(「プレイヤー名」，「レーティング」)
     * が分かっている．
     */
    class KisenIpxFile{
      std::ifstream ifs;
      size_t numberOfGames;
      const std::string file_name;
    public:
      enum{
	BY_PARITY=0,
	BLACK_WIN=1,
	WHITE_WIN=2,
	SENNNICHITE=3,
	JISHOGI=4,
	BLACK_WIN_256=5,
	WHITE_WIN_256=6,
	SENNNICHITE_256=7,
	JISHOGI_256=8,
      };
      explicit KisenIpxFile(std::string const& fileName);
      ~KisenIpxFile();
      
      size_t size() const{ return numberOfGames; }
      const std::string getPlayer(size_t index,Player pl);
      const std::string getTitle(size_t index,Player pl);
      unsigned int getRating(size_t index,Player pl);
      unsigned int getResult(size_t index);
      const std::string& getFileName() const { return file_name; }
    };
    /**
     * 「.kpf」という拡張子を持つ棋泉プラス形式ファイル.
     * 手や消費時間の情報が入っている
     */
    class KisenPlusFile{
    private:
      std::ifstream ifs;
      size_t numberOfGames;
      SimpleState const initialState;
    public:
      static const size_t maxMoves=256;
      explicit KisenPlusFile(const std::string& fileName);
      size_t size() const{ return numberOfGames; }
      SimpleState const& getInitialState() const{ return initialState; }
      const vector<Move> getMoves(size_t index);
      void getMoves(size_t index, vector<Move>&, vector<int>&);
    };

    class OKisenStream : public ORecordStream {
    public:
      OKisenStream(std::ostream &ostream) : os(ostream) { }
      void save(SimpleState state, const vector<Move> &moves);
      virtual void save(Record *);
      virtual ~OKisenStream() { }
    private:
      std::ostream &os;
    };

    /**
     * 「.ipx」という拡張子を持つ棋泉形式ファイル.
     * 対局者に関する情報(「プレイヤー名」，「レーティング」)
     * が分かっている．書かれるのは分かっている部分のみ。
     * 勝敗情報は不完全。千日手や持将棋の情報が Record にないため。
     */
    class KisenIpxWriter
    {
    public:
      KisenIpxWriter(std::ostream &ostream) : os(ostream) { }
      void save(const Record &,
		int black_rating, int white_rating,
		const std::string &black_title,
		const std::string &white_title);
    private:
      void writeString(const std::string &name, size_t length);
      void writeRating(int rating);
      std::ostream &os;
    };
  } // namespace record
  using record::KisenFile;
  using record::KisenIpxFile;
} // namespace osl
#endif // _KISEN_H 
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
