#ifndef _CSARECORD_H
#define _CSARECORD_H

#include "osl/record/record.h"
#include "osl/record/csa.h"
#include "osl/state/numEffectState.h"
#include <boost/shared_ptr.hpp>
#include <string>
#include <iosfwd>
namespace osl
{
  namespace record
  {
    namespace csa
    {
      class InputStream : public IRecordStream
      {
      private:
	std::istream& is;
	SimpleState state;
        boost::shared_ptr<RecordVisitor> rv;
      public:
	InputStream(std::istream& is);
	InputStream(std::istream& is, boost::shared_ptr<RecordVisitor> rv);
	virtual ~InputStream();

	/** @throw CsaIOError */
	virtual void load(Record*);
	const SimpleState& getState() const { return state;}
      };

      class CsaFile
      {
      private:
	Record rec;
      public:
	CsaFile(const std::string& fileName);
	~CsaFile();

	Record const& getRecord() const;
	const NumEffectState getInitialState() const;
      };

    } // namespace csa
  } // namespace record
  using record::csa::CsaFile;

} // namespace osl
#endif /* _CSARECORD_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
