/* readme.h
 */
#ifndef _README_H
#define _README_H

namespace osl
{
  /**
   * 低レベルの指手生成
   * 
   * このディレクトリには低レベルの指手生成コードが含まれている．
   *
   * 注意: 指手の合法性について
   * - isValid(Move), state.isValidMove な手を作る
   * - 指した後で玉の素抜きがある局面を生じる指手も生成される
   *  (上記の関数では素抜きは判定不能)
   *
   * 素抜き対策
   * - 局面を動かした後で hasEffectBy などで確認する
   * - SafeFilterをかけて手を生成する (CheckMoveGenerator ではそうしている)
   *
   * 現在提供されているクラス
   *
   * カテゴリに属する手をすべて生成
   *  - AllMoves<class Action>
   *  - Drop<class Action>
   *  - Promote<Player P,class Action,bool noCapture=true>
   *  primary methodを
   *   template<Player P> 
   *   static void generateMoves(const NumEffectState& state, Action& action);
   *  に決めうちした方が良い?
   *
   * カテゴリ+位置の指定
   *  - Capture<Player P>
   *  - GenerateCapture
   *  - AddEffectShort<Player P,Ptype T,bool isAttackToKing=false>
   *  - AddEffectLong<Player P,Ptype T,bool isAttackToKing=false>
   *  - AddEffect<Player P,bool isAttackToKing=false>
   *  primary methodを
   *   template<Player P> 
   *   static void generateMovesTarget(const NumEffectState& state, Position const& target, Action& action);
   *  に決めうちした方が良い?
   *
   * カテゴリ+駒の指定
   *  - Escape<Player P,class Action>
   *  - GenerateEscape<Player P>
   *  - GenerateEscapeOfTurn
   *  - PieceOnBoardDirUnsafe<Player P,Ptype T,PromoteType CanP,Direction Dir>
   *  - PieceOnBoardDir<Player P,Ptype T,Ptype MoveT,PromoteType CanP,Direction Dir>
   *  - PieceOnBoardTypePromotion<Player P,Ptype Type,Ptype MoveType,PromoteType CanP>
   *  - PieceOnBoardType<Player P, Ptype T>
   *  - PieceOnBoard<Player P>
   *  - KingWalk<Player P>
   *  primary methodを
   *   template<Player P> 
   *   static void generateMovesPiece(const NumEffectState& state, Piece const& piece, Action& action);
   *  に決めうちした方が良い?
   *
   * カテゴリ+駒+位置の指定
   *  - Open<Action>
   *  - GenerateOpen
   *  primary methodを
   *   template<Player P> 
   *   static void generateMovesPieceTarget(const NumEffectState& state, Piece const& piece, Position const& target,Action& action);
   *  に決めうちした方が良い?
   */
  namespace move_generator
  {
  }
}


#endif /* _README_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
