#ifndef _MOVE_GENERATOR_ADD_EFFECT_TCC
#define _MOVE_GENERATOR_ADD_EFFECT_TCC

#include "osl/move_generator/addEffect_.h"
#include "osl/move_action/safeFilter.h"
#include "osl/move_generator/open.h"
#include <boost/type_traits.hpp>

namespace osl
{
  namespace move_generator
  {
    namespace without_effect
    {
      /**
       * @param P(template) - 攻撃側のプレイヤー
       * @param T(template) - 攻撃側の駒の種類
       * @param state - 局面
       * @param from - 攻撃しようとする駒の位置
       * @param target - 攻撃しようとするマス
       * すでに攻撃しようとするマスに利きがある場合は何もしない?
       * 当然ながら，自分で動いてもとの位置に利きをつけるなどは考えない
       */
      template <Player P,Ptype T,class Action,bool isPromote>
      void generateMove(const NumEffectState& state,Position from,Position target, NearMask nearMask,Action& action)
      {
	NearMask target_mask = 
	  (isPromote 
	   ? Add_Effect_Table.getNearMaskWithPromote<P>(PtypeTraits<T>::moveType,from,target)
	   : Add_Effect_Table.getNearMask<P>(PtypeTraits<T>::moveType,from,target));
	target_mask &= nearMask;
	while (target_mask.any())
	{
	  const int n =target_mask.takeOneBit();
	  Direction dir=static_cast<Direction>(n);
	  Position to=target-Board_Table.template getOffset<P>(dir);
	  if (!isPromote || 
	      (from.canPromote<P>()||to.canPromote<P>()))
	    action.unknownMove(from,to,state.getPieceAt(to),(isPromote ? PtypeFuns<T>::promotePtype : T) ,isPromote,P);
	}
      }

      template <Player P,Ptype T,class Action>
      void generateLongMoveDirectNoPromote(const NumEffectState& state,Position from,Position target, NearMask nearMask,Action& action)
      {
	assert(state.getPieceAt(from).template isOnBoardByOwner<P>());
	NearMask target_mask=Add_Effect_Table.getNearMask<P>(T,from,target) &nearMask;
	while (target_mask.any())
	{
	  const int n = target_mask.takeOneBit();
	  Direction dir=static_cast<Direction>(n);
	  Position to=target-Board_Table.template getOffset<P>(dir);
	  /** 
	   * 間がすべて空白
	   */
	  if (state.hasEffectByPiece(state.getPieceAt(from),to))
	    action.unknownMove(from,to,state.getPieceAt(to),T,false,P);
	}
      }

      template <Player P,Ptype T,class Action>
      void generateLongMoveDirectCanPromote(const NumEffectState& state,Position from,Position target, NearMask nearMask,Action& action)
      {
	assert(state.getPieceAt(from).template isOnBoardByOwner<P>());
	NearMask target_mask=Add_Effect_Table.getNearMaskWithPromote<P>(T,from,target) &nearMask;
	NearMask target_mask_no_promote=Add_Effect_Table.getNearMask<P>(T,from,target) &nearMask;
	while (target_mask.any())
	{
	  const int n = target_mask.takeOneBit();
	  Direction dir=static_cast<Direction>(n);
	  Position to=target-Board_Table.template getOffset<P>(dir);
	  /** 
	   * 間がすべて空白
	   */
	  if (state.hasEffectByPiece(state.getPieceAt(from),to))
	  {
	    if (to.canPromote<P>()||from.canPromote<P>())
	      action.unknownMove(from,to,state.getPieceAt(to),PtypeFuns<T>::promotePtype,true,P);
	    if ((target_mask_no_promote.isSet(n))!=0)
	      action.unknownMove(from,to,state.getPieceAt(to),T,false,P);
	  }
	}
      }
      /**
       *
       */
      template<bool isAttackToKing>
      bool isEmptyOrAdditional(const NumEffectState& state,Position from,Position to,int& count)
      {
	count=0;
	if(isAttackToKing){
	  return state.isEmptyBetween(from,to);
	}
	Offset o=Board_Table.getShortOffset(Offset32(to,from));
	assert(!o.zero());
	Piece p;
	Position pos;
	for(pos=from+o;pos!=to && (p=state.getPieceAt(pos)).isEmpty();pos+=o)
	  ;
	if(pos==to) return true;
	assert(!p.isEdge());
	count=1;
	return state.hasEffectByPiece(p,to);
      }
      template <Player P,Ptype T,class Action,bool canPromote,bool isAttackToKing>
      void generateLongMove(const NumEffectState& state,Position from,Position target, NearMask nearMask,Action& action,int piece_num)
      {
	assert(state.getPieceAt(from).template isOnBoardByOwner<P>());
	// static assert?
	assert(T==LANCE || T==BISHOP || T==PBISHOP || T==ROOK || T==PROOK);
	/** longのofsetがある */
	const EffectContent effect_content=
	  Ptype_Table.getEffect(newPtypeO(BLACK,unpromote(T)),Offset32(target,from).blackOffset32<P>());
	if (isAttackToKing)
	{
	  assert(! effect_content.hasUnblockableEffect());
	}
	else if (effect_content.hasUnblockableEffect())
	  return;
	if (effect_content.hasEffect())
	{
	  /** 
	   * 同じlineでも可能性はある
	   */
	  if (T==PROOK)
	  {
	    generateMove<P,T,Action,false>(state,from,target,nearMask,action);
	  }
	  Direction longD=Board_Table.getLongDirection<BLACK>(from,target);
	  Direction shortD=longToShort(longD);
	  Piece p;
	  Position pos1;
	  if(isAttackToKing){
	    pos1=state.kingMobilityAbs(alt(P),shortD);
	    if(state.getMobility(shortD,piece_num)!=pos1) return;
	    p=state.getPieceAt(pos1);
	  }
	  else{
	    Offset o1=effect_content.offset().template blackOffset<P>();
	    assert(!o1.zero());
	    pos1=target-o1;
	    for(;(p=state.getPieceAt(pos1)).isEmpty();pos1-=o1) ;
	    if (pos1==from) return;
	    assert(!p.isEdge());
	    if(state.hasEffectByPiece(p,target)){
	      Piece p1;
	      Position pos3=pos1;
	      for(pos1-=o1;(p1=state.getPieceAt(pos1)).isEmpty();pos1-=o1) ;
	      if(pos1==from){
		if(p.isOnBoardByOwner<P>()) return;
		pos1=pos3;
	      }
	      else{
		p=p1;
		if (! state.hasEffectByPiece(state.getPieceAt(from), pos1))
		  return;
	      }
	    }
	    else{
	      if (! state.hasEffectByPiece(state.getPieceAt(from), pos1))
		return;
	    }
	  }
	  if (p.isOnBoardByOwner<P>())
	  { 
	    Open<Action>::template generate<P>
	      (state,p,action,target,
	       longToShort(Board_Table.getLongDirection<BLACK>(Offset32(target,from).blackOffset32<P>())));
	    /** open attack */
	  
	  }
	  else
	  {
	    /** capture attack */
	    if (canPromote &&          
		(from.canPromote<P>()||pos1.canPromote<P>()) &&
		/** LANCEの場合は直前以外は成ってはダメ */
		(T!=LANCE || 
		 pos1==target-DirectionPlayerTraits<U,P>::offset()))
	      action.unknownMove(from,pos1,p,PtypeFuns<T>::promotePtype,true,P);
	    action.unknownMove(from,pos1,p,T,false,P);
	  }
	}
	else
	{
	  /**
	   * 同じlineでない場合
	   * 8近傍に移動しての王手
	   */
	  if (!PtypeTraits<T>::isBasic)
	  {
	    generateLongMoveDirectNoPromote<P,T,Action>(state,from,target,nearMask,action);
	  }
	  else
	  {
	    generateLongMoveDirectCanPromote<P,T,Action>(state,from,target,nearMask,action);
	  }
	  if (T!=LANCE)
	  {
	    /** 一方向1position */
	    {
	      NearMask target_mask=Add_Effect_Table.getNearMaskLong<P>(T,from,target);
	      if(isAttackToKing) target_mask&=nearMask;
	      while (target_mask.any())
	      {
		const int n = target_mask.takeOneBit();
		Offset offset=Add_Effect_Table.getOffsetLong<P>(T,from,target,n&15);
		Position mid=target+offset.blackOffset<P>();
		/** 中間地点が範囲外のこともある */
		if (! mid.isOnBoard()) 
		  continue;
		Piece p=state.getPieceAt(mid);
		int count=0;
		if (p.canMoveOn<P>() 
		    && state.hasEffectByPiece(state.getPieceAt(from),mid)
		    && isEmptyOrAdditional<isAttackToKing>(state,mid,target,count))
		{
		  if (canPromote &&
		      (from.canPromote<P>()||mid.canPromote<P>()))
		    action.unknownMove(from,mid,p,PtypeFuns<T>::promotePtype,true,P);
		  action.unknownMove(from,mid,p,T,false,P);
		}
	      }
	    }
	    /** 一方向2position */
	    if (T==PBISHOP)
	    {
	      NearMask target_mask=Add_Effect_Table.getNearMaskPBISHOP<P>(from,target);
	      if(isAttackToKing) target_mask&=nearMask;
	      while (target_mask.any())
	      {
		const int n = target_mask.takeOneBit();
		Offset offset=Add_Effect_Table.getOffsetPBISHOP<P>(from,target,n&15);
		Position mid=target+offset.blackOffset<P>();
		/** */
		int count=0;
		if (isEmptyOrAdditional<isAttackToKing>(state,mid,target,count))
		{
		  for(int i=0;i<2;i++){
		    Piece p=state.getPieceAt(mid);
		    if(p.canMoveOn<P>()){
		      if (canPromote &&
			  (from.canPromote<P>()||mid.canPromote<P>()))
			action.unknownMove(from,mid,p,PtypeFuns<T>::promotePtype,true,P);
		      action.unknownMove(from,mid,p,T,false,P);
		    }
		    if (!p.isEmpty()){
		      if (isAttackToKing || count>0 || p.isEdge() || !state.hasEffectByPiece(p,target)) break;
		      count++;
		    }
		    mid=mid+Board_Table.getShortOffset(Offset32(mid,target));
		  }
		}
	      }
	    }
	    /** 一方向3position */
	    if (T==PROOK)
	    {
	      NearMask target_mask=Add_Effect_Table.getNearMaskPROOK<P>(from,target);
	      if(isAttackToKing) target_mask&=nearMask;
	      while (target_mask.any())
	      {
		const int n = target_mask.takeOneBit();
		Offset offset=Add_Effect_Table.getOffsetPROOK<P>(from,target,n&15);
		Position mid=target+offset.blackOffset<P>();
		/** */
		int count=0;
		if (isEmptyOrAdditional<isAttackToKing>(state,mid,target,count))
		{
		  for(int i=0;i<3;i++)
		  {
		    Piece p=state.getPieceAt(mid);
		    if(p.canMoveOn<P>()){
		      if (canPromote &&
			  (from.canPromote<P>()||mid.canPromote<P>()))
			action.unknownMove(from,mid,p,PtypeFuns<T>::promotePtype,true,P);
		      action.unknownMove(from,mid,p,T,false,P);
		    }
		    if (!p.isEmpty()){
		      if (isAttackToKing || count>0 || p.isEdge() || !state.hasEffectByPiece(p,target)) break;
		      count++;
		    }
		    mid=mid+Board_Table.getShortOffset(Offset32(mid,target));
		  }
		}
	      }
	    }
	  }
	}
      }

      template <Player P,Ptype T,class Action,bool isLong,bool isAttackToKing>
      void generateDrop(const NumEffectState& state,Position target, NearMask nearMask,Action& action)
      {
	NearMask target_mask
	  = (isLong ? NearMask::makeDirect(PtypeTraits<T>::moveMask>>10) :
	     NearMask::makeDirect(PtypeTraits<T>::moveMask<<16) & nearMask);
	if(isAttackToKing && isLong) target_mask&=nearMask;
	while (target_mask.any())
	{
	  const int n = target_mask.takeOneBit();
	  Direction dir=static_cast<Direction>(n&15);
	  Offset offset=Board_Table.template getOffset<P>(dir);
	  Position to=target-offset;
	  if (isLong)
	  {
	    Piece p;
	    Position pos1;
	    for(pos1=to;(p=state.getPieceAt(pos1)).isEmpty();pos1-=offset)
	      action.dropMove(pos1,T,P);
	    if(isAttackToKing || p.isEdge() || !state.hasEffectByPiece(p,target)) continue;
	    for(pos1-=offset;state.getPieceAt(pos1).isEmpty();pos1-=offset)
	      action.dropMove(pos1,T,P);
	    
	  }
	  /** 二歩の禁止 */
	  else if (T!=PAWN || !state.template isPawnMaskSet<P>(to.x()))
	    action.dropMove(to,T,P);
	} 
      }

      /**
       * promote不可能な足の短い駒による利きの生成用 Functor
       */
      template <Player P,Ptype T,class Action>
      class GoldKingAction
      {
	const NumEffectState& state;
	Position target;
	Action& action;
	NearMask nearMask;
      public:
	GoldKingAction(const NumEffectState& s,Position p,Action& a,NearMask n)
	  :state(s),target(p),action(a),nearMask(n)
        {}
	/**
	 * forEachOnBoardから呼ばれる
	 */
	void operator()(Piece p)
        {
	  Position from=p.position();
	  generateMove<P,T,Action,false>(state,from,target,nearMask,action);
	}
      };
  
      /**
       * promote可能な足の短い駒による利きの生成用 Functor
       */
      template <Player P,Ptype T,class Action>
      class ShortPieceAction
      {
	const NumEffectState& state;
	Position target;
	Action& action;
	NearMask nearMask;
      public:
	ShortPieceAction(const NumEffectState& s,Position p,Action& a,NearMask n)
	  :state(s),target(p),action(a),nearMask(n)
	{}
	/**
	 * forEachOnBoardから呼ばれる
	 */
	void operator()(Piece p)
        {
	  Position from=p.position();
	  if (p.isPromotedNotKingGold())
	  {
	    generateMove<P,PtypeFuns<T>::promotePtype,Action,false>(state,from,target,nearMask,action);
	  }
	  else
	  {
	    generateMove<P,T,Action,true>(state,from,target,nearMask,action);
	    generateMove<P,T,Action,false>(state,from,target,nearMask,action);
	  }  
	}
      };

      /**
       * 足の長い駒による利きの生成用 Functor
       */
      template <Player P,Ptype T,class Action,bool isAttackToKing>
      class LongPieceAction
      {
	const NumEffectState& state;
	Position target;
	Action& action;
	NearMask nearMask;
      public:
	LongPieceAction(const NumEffectState& s,Position p,Action& a,NearMask n)
	  :state(s),target(p),action(a),nearMask(n)
        {}
	/**
	 * forEachOnBoardから呼ばれる
	 */
	void operator()(Piece p)
	{
	  Position from=p.position();
	  int num=p.number();
	  if (p.isPromotedNotKingGold())
	  {
	    if (T==LANCE)
	      generateMove<P,PtypeFuns<T>::promotePtype,Action,false>(state,from,target,nearMask,action);
	    else
	    {
	      generateLongMove<P,PtypeFuns<T>::promotePtype,Action,false,isAttackToKing>(state,from,target,nearMask,action,num);
	    }
	  }
          else
          {
            generateLongMove<P,T,Action,true,isAttackToKing>(state,from,target,nearMask,action,num);
          }  
        }
      };

    } // namespace without_effect
  } // namespace move_generator
} // namespace osl

template <osl::Player P,osl::Ptype T,bool isAttackToKing>
template <class Action>
void osl::move_generator::AddEffectShort<P,T,isAttackToKing>::
generate(const NumEffectState& state,Position target,Action& action,NearMask nearMask)
{
  BOOST_STATIC_ASSERT((PtypeTraits<T>::isBasic));
  BOOST_STATIC_ASSERT((PtypeTraits<T>::canPromote));
  typedef without_effect::ShortPieceAction<P,T,Action> action_t;
  action_t gkAction(state,target,action,nearMask);
  state.template forEachOnBoard<P,T,action_t>(gkAction);
  /** drop move */
  if (state.template hasPieceOnStand<T>(P))
  {
    without_effect::generateDrop<P,T,Action,false,isAttackToKing>(state,target,nearMask,action);
  }
}

template <osl::Player P,osl::Ptype T,bool isAttackToKing>
template <class Action>
void osl::move_generator::AddEffectLong<P,T,isAttackToKing>::
generate(const NumEffectState& state,Position target,Action& action,NearMask nearMask)
{
  typedef without_effect::LongPieceAction<P,T,Action,isAttackToKing> action_t;
  action_t gkAction(state,target,action,nearMask);
  state.template forEachOnBoard<P,T,action_t>(gkAction);
  /** drop move */
  if (state.template hasPieceOnStand<T>(P))
  {
    without_effect::generateDrop<P,T,Action,true,isAttackToKing>(state,target,nearMask,action);
  }
}

template <osl::Player P,bool isAttackToKing>
template <class Action>
void osl::move_generator::AddEffect<P,isAttackToKing>::
generateKing(const NumEffectState& state,Position target,Action& action,NearMask nearMask)
{
  typedef without_effect::GoldKingAction<P,KING,Action> action_t;
  action_t gkAction(state,target,action,nearMask);
  state.template forEachOnBoard<P,KING,action_t>(gkAction);
}

template <osl::Player P,bool isAttackToKing>
template <class Action>
void osl::move_generator::AddEffect<P,isAttackToKing>::
generateGold(const NumEffectState& state,Position target,Action& action,NearMask nearMask)
{
  typedef without_effect::GoldKingAction<P,GOLD,Action> action_t;
  action_t gkAction(state,target,action,nearMask);
  state.template forEachOnBoard<P,GOLD,action_t>(gkAction);
  /** drop move */
  if (state.template hasPieceOnStand<GOLD>(P))
  {
    without_effect::generateDrop<P,GOLD,Action,false,isAttackToKing>(state,target,nearMask,action);
  }
}

template <osl::Player P,bool isAttackToKing>
template <class Action>
void osl::move_generator::AddEffect<P,isAttackToKing>::
generate(const NumEffectState& state,Position target,Action& action)
{
//  BOOST_STATIC_ASSERT(!isAttackToKing);
  NearMask nearMask=NearMask::make<P>(state,target);
  /* 各種類によるmove */
  AddEffectShort<P,PAWN,isAttackToKing>::generate(state,target,action,nearMask);
  AddEffectLong<P,LANCE,isAttackToKing>::generate(state,target,action,nearMask);
  AddEffectShort<P,KNIGHT,isAttackToKing>::generate(state,target,action,nearMask);
  AddEffectShort<P,SILVER,isAttackToKing>::generate(state,target,action,nearMask);
  generateGold(state,target,action,nearMask);
  if (!isAttackToKing)
    generateKing(state,target,action,nearMask);
  AddEffectLong<P,BISHOP,isAttackToKing>::generate(state,target,action,nearMask);
  AddEffectLong<P,ROOK,isAttackToKing>::generate(state,target,action,nearMask);
}

template<bool isAttackToKing>
void osl::move_generator::GenerateAddEffect<isAttackToKing>::
generate(Player player, const NumEffectState& state, Position target, 
	 move_action::Store& store)
{
  using namespace osl::move_action;
  if(player==BLACK)
  {
    SafeFilter<BLACK,Store> filter(state, store);
    AddEffect<BLACK,isAttackToKing>::generate(state,target,filter);
  }
  else
  {
    SafeFilter<WHITE,Store> filter(state, store);
    AddEffect<WHITE,isAttackToKing>::generate(state,target,filter);
  }
}

#endif /* _MOVE_GENERATOR_ADD_EFFECT_TCC */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
