/* storeMoveAction.h
 */
#ifndef _STOREMOVEACTION_H
#define _STOREMOVEACTION_H
#include "osl/container/moveVector.h"
#include "osl/piece.h"

namespace osl
{
  namespace move_action
  {
    /**
     * 指手を MoveVector に保管
     */
    struct Store
    {
      FixedCapacityVectorPushBack<Move> moves;
      template <size_t Capacity>
      explicit Store(FixedCapacityVector<Move, Capacity>& v) 
	: moves(v.pushBackHelper())
      {
      }
      /** コマをとらないMove */
      void simpleMove(Position /*from*/,Position /*to*/,Ptype /*ptype*/, bool /*isPromote*/,Player /*p*/,Move move){
	assert(move.isValid());
	moves.push_back(move);
      }
      /** 
       *	コマを取るかもしれないMove 
       * @param from - 駒の移動元
       * @param to - 駒の移動先
       * @param p1 - 移動先のマスの駒
       * @param ptype - 移動後の駒のptype
       * @param isPromote - 成りか?
       * @param p - プレイヤー
       */
      void unknownMove(Position /*from*/,Position /*to*/,Piece /*p1*/,Ptype /*ptype*/,bool /*isPromote*/,Player /*p*/,Move move)
      {
	assert(move.isValid());
	moves.push_back(move);
      }
      /** コマを打つMove */
      void dropMove(Position /*to*/,Ptype /*ptype*/,Player /*p*/,Move move)
      {
	assert(move.isValid());
	moves.push_back(move);
      }
      // old interfaces
      void simpleMove(Position from,Position to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,
		   Move(from,to,ptype,PTYPE_EMPTY,isPromote,p));
      }
      void unknownMove(Position from,Position to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,
		    Move(from,to,ptype,captured.ptype(),isPromote,p));
      }
      void dropMove(Position to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,
		 Move(to,ptype,p));
      }
    };
  } // namespace move_action
} // namespace osl

#endif /* INCLUDED_STOREMOVEACTION */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
