/* centering3x3.h
 */
#ifndef OSL_CENTERING3X3_H
#define OSL_CENTERING3X3_H

#include "osl/position.h"
#include "osl/misc/carray.h"

namespace osl
{
  /**
   * 3x3が盤上におさまるように中心を調整
   */
  struct Centering3x3
  {
    struct Table 
    {
      CArray<Position,Position::SIZE> centers;
      Table();
    };
    static const Position adjustCenterNaive(Position);
    static const Table table;
    static const Position adjustCenter(Position src)
    {
      return table.centers[src.index()];
    }
  };

} // namespace osl

#endif /* OSL_CENTERING3X3_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
