/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.caucho.hessian;

import java.io.IOException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

import mx4j.tools.remote.http.HTTPConnectionMBeanServerConnection;
import mx4j.tools.remote.http.HTTPConnector;

/**
 * A JSR 160 implementation of a JMXConnector over Caucho's Hessian protocol
 * (http://www.caucho.com/hessian).
 * <br/>
 * IMPORTANT NOTE: <br/>
 * This JMXConnector is still in experimental status, so compatibility with
 * newer version may broke, especially regarding hessian serialization of JMX classes.
 *
 * @version $Revision: 1.4 $
 * @see mx4j.tools.remote.caucho.burlap.BurlapConnector
 */
public class HessianConnector extends HTTPConnector
{
   public HessianConnector(JMXServiceURL address, Map environment) throws IOException
   {
      super(address);
   }

   protected MBeanServerConnection doGetMBeanServerConnection(Subject delegate) throws IOException
   {
      return new HTTPConnectionMBeanServerConnection(getHTTPConnection(), delegate, getRemoteNotificationClientHandler());
   }
}
