/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.interceptor;

/**
 * This exception is only used internally by the {@link AdaptorInterceptor} class, to
 * avoid that interceptors do too much exception logging.
 *
 * @version $Revision: 1.3 $
 */
public class AdaptorInterceptorException extends Exception
{
   private Exception m_target;

   public AdaptorInterceptorException(Exception target)
   {
      m_target = target;
   }

   public Exception getTargetException()
   {
      return m_target;
   }
}
