/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.server.interceptor;

import mx4j.MBeanDescriptionAdapter;

import java.lang.reflect.Method;
import java.lang.reflect.Constructor;

/**
 * Management interface description for the SecurityMBeanServerInterceptor MBean.
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class SecurityMBeanServerInterceptorMBeanDescription extends MBeanDescriptionAdapter
{
   public String getMBeanDescription()
   {
      return "The interceptor that performs security checks for MBeanServer to MBean calls";
   }

   public String getAttributeDescription(String attribute)
   {
      if (attribute.equals("Type"))
      {
         return "The type of this interceptor";
      }
      if (attribute.equals("Enabled"))
      {
         return "This interceptor is always enabled and cannot be disabled";
      }
      return super.getAttributeDescription(attribute);
   }
}
