/* text-bigram-language-model.c generated by valac 0.24.0.131-42e78, the Vala compiler
 * generated from text-bigram-language-model.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;
typedef struct _KkcLanguageModelPrivate KkcLanguageModelPrivate;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;

#define KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL (kkc_text_bigram_language_model_get_type ())
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel))
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelClass))
#define KKC_IS_TEXT_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL))
#define KKC_IS_TEXT_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL))
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelClass))

typedef struct _KkcTextBigramLanguageModel KkcTextBigramLanguageModel;
typedef struct _KkcTextBigramLanguageModelClass KkcTextBigramLanguageModelClass;
typedef struct _KkcTextBigramLanguageModelPrivate KkcTextBigramLanguageModelPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_LANGUAGE_MODEL_METADATA (kkc_language_model_metadata_get_type ())
#define KKC_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata))
#define KKC_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))
#define KKC_IS_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_IS_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_LANGUAGE_MODEL_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))

typedef struct _KkcLanguageModelMetadata KkcLanguageModelMetadata;
typedef struct _KkcLanguageModelMetadataClass KkcLanguageModelMetadataClass;

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcLanguageModel {
	GObject parent_instance;
	KkcLanguageModelPrivate * priv;
};

struct _KkcLanguageModelClass {
	GObjectClass parent_class;
	GeeCollection* (*unigram_entries) (KkcLanguageModel* self, const gchar* input);
	GeeCollection* (*entries) (KkcLanguageModel* self, const gchar* input);
	KkcLanguageModelEntry* (*get) (KkcLanguageModel* self, const gchar* input, const gchar* output);
	gboolean (*parse) (KkcLanguageModel* self, GError** error);
	void (*get_bos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
	void (*get_eos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcTextBigramLanguageModel {
	KkcLanguageModel parent_instance;
	KkcTextBigramLanguageModelPrivate * priv;
	GeeMap* input_map;
	GeeMap* cost_map;
	GeeMap* backoff_map;
	GeeMap* id_map;
};

struct _KkcTextBigramLanguageModelClass {
	KkcLanguageModelClass parent_class;
};

struct _KkcTextBigramLanguageModelPrivate {
	KkcLanguageModelEntry _bos;
	KkcLanguageModelEntry _eos;
};


static gpointer kkc_text_bigram_language_model_parent_class = NULL;
static KkcUnigramLanguageModelIface* kkc_text_bigram_language_model_kkc_unigram_language_model_parent_iface = NULL;
static KkcBigramLanguageModelIface* kkc_text_bigram_language_model_kkc_bigram_language_model_parent_iface = NULL;

GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_text_bigram_language_model_get_type (void) G_GNUC_CONST;
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelPrivate))
enum  {
	KKC_TEXT_BIGRAM_LANGUAGE_MODEL_DUMMY_PROPERTY,
	KKC_TEXT_BIGRAM_LANGUAGE_MODEL_BOS,
	KKC_TEXT_BIGRAM_LANGUAGE_MODEL_EOS
};
static gdouble* _double_dup (gdouble* self);
static GeeCollection* kkc_text_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* input);
static GeeCollection* kkc_text_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input);
static KkcLanguageModelEntry* kkc_text_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output);
gchar* kkc_text_bigram_language_model_get_key (KkcTextBigramLanguageModel* self, guint* ids, int ids_length1);
static gboolean kkc_text_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_text_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
void kkc_text_bigram_language_model_parse_lm (KkcTextBigramLanguageModel* self, const gchar* input, GError** error);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
static gboolean kkc_text_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_language_model_metadata_get_type (void) G_GNUC_CONST;
KkcLanguageModelMetadata* kkc_language_model_get_metadata (KkcLanguageModel* self);
const gchar* kkc_metadata_file_get_filename (KkcMetadataFile* self);
KkcTextBigramLanguageModel* kkc_text_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error);
KkcTextBigramLanguageModel* kkc_text_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
KkcLanguageModel* kkc_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
static void kkc_text_bigram_language_model_finalize (GObject* obj);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
static void _vala_kkc_text_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gdouble* _double_dup (gdouble* self) {
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}


static GeeCollection* kkc_text_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* input) {
	KkcTextBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = self->input_map;
	_tmp1_ = input;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	result = (GeeCollection*) ((GeeArrayList*) _tmp2_);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeCollection* kkc_text_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input) {
	KkcTextBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp20_ = NULL;
	GeeCollection* _tmp21_ = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL, NULL, NULL);
	entries = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				glong byte_offset = 0L;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gchar* str = NULL;
				const gchar* _tmp9_ = NULL;
				glong _tmp10_ = 0L;
				gchar* _tmp11_ = NULL;
				GeeMap* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = input;
				_tmp5_ = g_utf8_strlen (_tmp4_, (gssize) (-1));
				if (!(_tmp3_ < (_tmp5_ + 1))) {
					break;
				}
				_tmp6_ = input;
				_tmp7_ = i;
				_tmp8_ = string_index_of_nth_char (_tmp6_, (glong) _tmp7_);
				byte_offset = (glong) _tmp8_;
				_tmp9_ = input;
				_tmp10_ = byte_offset;
				_tmp11_ = string_substring (_tmp9_, (glong) 0, _tmp10_);
				str = _tmp11_;
				_tmp12_ = self->input_map;
				_tmp13_ = str;
				_tmp14_ = gee_map_has_key (_tmp12_, _tmp13_);
				if (_tmp14_) {
					GeeArrayList* _tmp15_ = NULL;
					GeeMap* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					GeeArrayList* _tmp19_ = NULL;
					_tmp15_ = entries;
					_tmp16_ = self->input_map;
					_tmp17_ = str;
					_tmp18_ = gee_map_get (_tmp16_, _tmp17_);
					_tmp19_ = (GeeArrayList*) _tmp18_;
					gee_array_list_add_all (_tmp15_, (GeeCollection*) _tmp19_);
					_g_object_unref0 (_tmp19_);
				}
				_g_free0 (str);
			}
		}
	}
	_tmp20_ = entries;
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
	result = _tmp21_;
	_g_object_unref0 (entries);
	return result;
}


static KkcLanguageModelEntry* kkc_text_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output) {
	KkcTextBigramLanguageModel * self;
	KkcLanguageModelEntry* result = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (output != NULL, NULL);
	result = NULL;
	return result;
}


gchar* kkc_text_bigram_language_model_get_key (KkcTextBigramLanguageModel* self, guint* ids, int ids_length1) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	guint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GString* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = ids;
	_tmp1__length1 = ids_length1;
	{
		guint* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp1_;
		id_collection_length1 = _tmp1__length1;
		for (id_it = 0; id_it < _tmp1__length1; id_it = id_it + 1) {
			guint id = 0U;
			id = id_collection[id_it];
			{
				GString* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				_tmp2_ = builder;
				_tmp3_ = id;
				g_string_append_printf (_tmp2_, "%08X", _tmp3_);
			}
		}
	}
	_tmp4_ = builder;
	_tmp5_ = _tmp4_->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_string_free0 (builder);
	return result;
}


static gboolean kkc_text_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gboolean result = FALSE;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	KkcLanguageModelEntry _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint* _tmp4_ = NULL;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GeeMap* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, FALSE);
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = *pentry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = *entry;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = g_new0 (guint, 2);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = kkc_text_bigram_language_model_get_key (self, _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	key = _tmp7_;
	_tmp8_ = self->cost_map;
	_tmp9_ = gee_map_has_key (_tmp8_, (const gchar*) key);
	result = _tmp9_;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	guint* _tmp2_ = NULL;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GeeMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = g_new0 (guint, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = kkc_text_bigram_language_model_get_key (self, _tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	key = _tmp5_;
	_tmp6_ = self->cost_map;
	_tmp7_ = key;
	_tmp8_ = gee_map_has_key (_tmp6_, _tmp7_);
	if (_tmp8_) {
		GeeMap* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
		gdouble* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		_tmp9_ = self->cost_map;
		_tmp10_ = key;
		_tmp11_ = gee_map_get (_tmp9_, _tmp10_);
		_tmp12_ = (gdouble*) _tmp11_;
		_tmp13_ = *_tmp12_;
		_g_free0 (_tmp12_);
		result = _tmp13_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	guint* _tmp2_ = NULL;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GeeMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = g_new0 (guint, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = kkc_text_bigram_language_model_get_key (self, _tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	key = _tmp5_;
	_tmp6_ = self->backoff_map;
	_tmp7_ = key;
	_tmp8_ = gee_map_has_key (_tmp6_, _tmp7_);
	if (_tmp8_) {
		GeeMap* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
		gdouble* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		_tmp9_ = self->backoff_map;
		_tmp10_ = key;
		_tmp11_ = gee_map_get (_tmp9_, _tmp10_);
		_tmp12_ = (gdouble*) _tmp11_;
		_tmp13_ = *_tmp12_;
		_g_free0 (_tmp12_);
		result = _tmp13_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	KkcLanguageModelEntry _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint* _tmp4_ = NULL;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GeeMap* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = *entry;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = g_new0 (guint, 2);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = kkc_text_bigram_language_model_get_key (self, _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	key = _tmp7_;
	_tmp8_ = self->cost_map;
	_tmp9_ = key;
	_tmp10_ = gee_map_has_key (_tmp8_, _tmp9_);
	if (_tmp10_) {
		GeeMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		gdouble* _tmp14_ = NULL;
		gdouble _tmp15_ = 0.0;
		_tmp11_ = self->cost_map;
		_tmp12_ = key;
		_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
		_tmp14_ = (gdouble*) _tmp13_;
		_tmp15_ = *_tmp14_;
		_g_free0 (_tmp14_);
		result = _tmp15_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gdouble kkc_text_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcTextBigramLanguageModel * self;
	gdouble result = 0.0;
	gchar* key = NULL;
	KkcLanguageModelEntry _tmp0_ = {0};
	guint _tmp1_ = 0U;
	KkcLanguageModelEntry _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint* _tmp4_ = NULL;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GeeMap* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	self = (KkcTextBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = *entry;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = g_new0 (guint, 2);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = kkc_text_bigram_language_model_get_key (self, _tmp5_, 2);
	_tmp7_ = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	key = _tmp7_;
	_tmp8_ = self->backoff_map;
	_tmp9_ = key;
	_tmp10_ = gee_map_has_key (_tmp8_, _tmp9_);
	if (_tmp10_) {
		GeeMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		gdouble* _tmp14_ = NULL;
		gdouble _tmp15_ = 0.0;
		_tmp11_ = self->backoff_map;
		_tmp12_ = key;
		_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
		_tmp14_ = (gdouble*) _tmp13_;
		_tmp15_ = *_tmp14_;
		_g_free0 (_tmp14_);
		result = _tmp15_;
		_g_free0 (key);
		return result;
	}
	result = (gdouble) 0;
	_g_free0 (key);
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void kkc_text_bigram_language_model_parse_lm (KkcTextBigramLanguageModel* self, const gchar* input, GError** error) {
	GFile* lm_file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInputStream* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFileInputStream* _tmp4_ = NULL;
	GDataInputStream* lm_data = NULL;
	GDataInputStream* _tmp5_ = NULL;
	guint id = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	_tmp0_ = input;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	lm_file = _tmp1_;
	_tmp3_ = lm_file;
	_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (lm_file);
		return;
	}
	_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
	lm_data = _tmp5_;
	while (TRUE) {
		gsize length = 0UL;
		gchar* line = NULL;
		GDataInputStream* _tmp6_ = NULL;
		gsize _tmp7_ = 0UL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp6_ = lm_data;
		_tmp8_ = g_data_input_stream_read_line (_tmp6_, &_tmp7_, NULL, &_inner_error_);
		length = _tmp7_;
		line = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (lm_data);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (lm_file);
			return;
		}
		_tmp9_ = line;
		if (_tmp9_ == NULL) {
			_g_free0 (line);
			break;
		}
		_tmp10_ = line;
		_tmp11_ = string_strip (_tmp10_);
		_g_free0 (line);
		line = _tmp11_;
		_tmp12_ = line;
		if (g_strcmp0 (_tmp12_, "") == 0) {
			_g_free0 (line);
			continue;
		}
		_tmp13_ = line;
		_tmp14_ = g_str_has_prefix (_tmp13_, "\\1-grams:");
		if (_tmp14_) {
			_g_free0 (line);
			break;
		}
		_g_free0 (line);
	}
	id = (guint) 0;
	while (TRUE) {
		gsize length = 0UL;
		gchar* line = NULL;
		GDataInputStream* _tmp15_ = NULL;
		gsize _tmp16_ = 0UL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_ = NULL;
		gchar** strv = NULL;
		const gchar* _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		gdouble cost = 0.0;
		gchar** _tmp83_ = NULL;
		gint _tmp83__length1 = 0;
		const gchar* _tmp84_ = NULL;
		gdouble _tmp85_ = 0.0;
		gdouble backoff = 0.0;
		gchar** _tmp86_ = NULL;
		gint _tmp86__length1 = 0;
		gchar** words = NULL;
		gchar** _tmp90_ = NULL;
		gint _tmp90__length1 = 0;
		const gchar* _tmp91_ = NULL;
		gchar** _tmp92_ = NULL;
		gchar** _tmp93_ = NULL;
		gint words_length1 = 0;
		gint _words_size_ = 0;
		guint* ids = NULL;
		guint* _tmp94_ = NULL;
		gint ids_length1 = 0;
		gint _ids_size_ = 0;
		gchar** _tmp95_ = NULL;
		gint _tmp95__length1 = 0;
		gchar* key = NULL;
		guint* _tmp101_ = NULL;
		gint _tmp101__length1 = 0;
		gchar* _tmp102_ = NULL;
		GeeMap* _tmp103_ = NULL;
		const gchar* _tmp104_ = NULL;
		gdouble _tmp105_ = 0.0;
		GeeMap* _tmp106_ = NULL;
		const gchar* _tmp107_ = NULL;
		gdouble _tmp108_ = 0.0;
		_tmp15_ = lm_data;
		_tmp17_ = g_data_input_stream_read_line (_tmp15_, &_tmp16_, NULL, &_inner_error_);
		length = _tmp16_;
		line = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (lm_data);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (lm_file);
			return;
		}
		_tmp18_ = line;
		if (_tmp18_ == NULL) {
			_g_free0 (line);
			break;
		}
		_tmp19_ = line;
		_tmp20_ = string_strip (_tmp19_);
		_g_free0 (line);
		line = _tmp20_;
		_tmp22_ = line;
		if (g_strcmp0 (_tmp22_, "") == 0) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = line;
			_tmp24_ = g_str_has_prefix (_tmp23_, "\\");
			_tmp21_ = _tmp24_;
		}
		if (_tmp21_) {
			_g_free0 (line);
			continue;
		}
		_tmp25_ = line;
		_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "\t", 0);
		strv = _tmp27_;
		strv_length1 = _vala_array_length (_tmp26_);
		_strv_size_ = strv_length1;
		_tmp28_ = strv;
		_tmp28__length1 = strv_length1;
		_tmp29_ = _tmp28_[1];
		_tmp30_ = string_contains (_tmp29_, " ");
		if (!_tmp30_) {
			GeeMap* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			const gchar* _tmp33_ = NULL;
			guint _tmp34_ = 0U;
			gchar** input_output = NULL;
			gint input_output_length1 = 0;
			gint _input_output_size_ = 0;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
			gchar** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			const gchar* _tmp38_ = NULL;
			KkcLanguageModelEntry entry = {0};
			gchar** _tmp52_ = NULL;
			gint _tmp52__length1 = 0;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			guint _tmp58_ = 0U;
			KkcLanguageModelEntry _tmp59_ = {0};
			gchar** _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			const gchar* _tmp61_ = NULL;
			GeeMap* _tmp68_ = NULL;
			gchar** _tmp69_ = NULL;
			gint _tmp69__length1 = 0;
			const gchar* _tmp70_ = NULL;
			gboolean _tmp71_ = FALSE;
			GeeMap* _tmp77_ = NULL;
			gchar** _tmp78_ = NULL;
			gint _tmp78__length1 = 0;
			const gchar* _tmp79_ = NULL;
			gpointer _tmp80_ = NULL;
			GeeArrayList* _tmp81_ = NULL;
			KkcLanguageModelEntry _tmp82_ = {0};
			_tmp31_ = self->id_map;
			_tmp32_ = strv;
			_tmp32__length1 = strv_length1;
			_tmp33_ = _tmp32_[1];
			_tmp34_ = id;
			gee_map_set (_tmp31_, _tmp33_, (gpointer) ((guintptr) _tmp34_));
			_tmp37_ = strv;
			_tmp37__length1 = strv_length1;
			_tmp38_ = _tmp37_[1];
			if (g_strcmp0 (_tmp38_, "<s>") == 0) {
				_tmp36_ = TRUE;
			} else {
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				const gchar* _tmp40_ = NULL;
				_tmp39_ = strv;
				_tmp39__length1 = strv_length1;
				_tmp40_ = _tmp39_[1];
				_tmp36_ = g_strcmp0 (_tmp40_, "</s>") == 0;
			}
			if (_tmp36_) {
				_tmp35_ = TRUE;
			} else {
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				const gchar* _tmp42_ = NULL;
				_tmp41_ = strv;
				_tmp41__length1 = strv_length1;
				_tmp42_ = _tmp41_[1];
				_tmp35_ = g_strcmp0 (_tmp42_, "<UNK>") == 0;
			}
			if (_tmp35_) {
				gchar* _tmp43_ = NULL;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				_tmp43_ = g_strdup (" ");
				_tmp44_ = strv;
				_tmp44__length1 = strv_length1;
				_tmp45_ = _tmp44_[1];
				_tmp46_ = g_strdup (_tmp45_);
				_tmp47_ = g_new0 (gchar*, 2 + 1);
				_tmp47_[0] = _tmp43_;
				_tmp47_[1] = _tmp46_;
				input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
				input_output = _tmp47_;
				input_output_length1 = 2;
				_input_output_size_ = input_output_length1;
			} else {
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				const gchar* _tmp49_ = NULL;
				gchar** _tmp50_ = NULL;
				gchar** _tmp51_ = NULL;
				_tmp48_ = strv;
				_tmp48__length1 = strv_length1;
				_tmp49_ = _tmp48_[1];
				_tmp51_ = _tmp50_ = g_strsplit (_tmp49_, "/", 0);
				input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
				input_output = _tmp51_;
				input_output_length1 = _vala_array_length (_tmp50_);
				_input_output_size_ = input_output_length1;
			}
			_tmp52_ = input_output;
			_tmp52__length1 = input_output_length1;
			_tmp53_ = _tmp52_[0];
			_tmp54_ = g_strdup (_tmp53_);
			_tmp55_ = input_output;
			_tmp55__length1 = input_output_length1;
			_tmp56_ = _tmp55_[1];
			_tmp57_ = g_strdup (_tmp56_);
			_tmp58_ = id;
			id = _tmp58_ + 1;
			_g_free0 (_tmp59_.input);
			_tmp59_.input = _tmp54_;
			_g_free0 (_tmp59_.output);
			_tmp59_.output = _tmp57_;
			_tmp59_.id = _tmp58_;
			entry = _tmp59_;
			_tmp60_ = strv;
			_tmp60__length1 = strv_length1;
			_tmp61_ = _tmp60_[1];
			if (g_strcmp0 (_tmp61_, "<s>") == 0) {
				KkcLanguageModelEntry _tmp62_ = {0};
				KkcLanguageModelEntry _tmp63_ = {0};
				_tmp62_ = entry;
				kkc_language_model_entry_copy (&_tmp62_, &_tmp63_);
				kkc_language_model_entry_destroy (&self->priv->_bos);
				self->priv->_bos = _tmp63_;
			} else {
				gchar** _tmp64_ = NULL;
				gint _tmp64__length1 = 0;
				const gchar* _tmp65_ = NULL;
				_tmp64_ = strv;
				_tmp64__length1 = strv_length1;
				_tmp65_ = _tmp64_[1];
				if (g_strcmp0 (_tmp65_, "</s>") == 0) {
					KkcLanguageModelEntry _tmp66_ = {0};
					KkcLanguageModelEntry _tmp67_ = {0};
					_tmp66_ = entry;
					kkc_language_model_entry_copy (&_tmp66_, &_tmp67_);
					kkc_language_model_entry_destroy (&self->priv->_eos);
					self->priv->_eos = _tmp67_;
				}
			}
			_tmp68_ = self->input_map;
			_tmp69_ = input_output;
			_tmp69__length1 = input_output_length1;
			_tmp70_ = _tmp69_[0];
			_tmp71_ = gee_map_has_key (_tmp68_, _tmp70_);
			if (!_tmp71_) {
				GeeMap* _tmp72_ = NULL;
				gchar** _tmp73_ = NULL;
				gint _tmp73__length1 = 0;
				const gchar* _tmp74_ = NULL;
				GeeArrayList* _tmp75_ = NULL;
				GeeArrayList* _tmp76_ = NULL;
				_tmp72_ = self->input_map;
				_tmp73_ = input_output;
				_tmp73__length1 = input_output_length1;
				_tmp74_ = _tmp73_[0];
				_tmp75_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL, NULL, NULL);
				_tmp76_ = _tmp75_;
				gee_map_set (_tmp72_, _tmp74_, _tmp76_);
				_g_object_unref0 (_tmp76_);
			}
			_tmp77_ = self->input_map;
			_tmp78_ = input_output;
			_tmp78__length1 = input_output_length1;
			_tmp79_ = _tmp78_[0];
			_tmp80_ = gee_map_get (_tmp77_, _tmp79_);
			_tmp81_ = (GeeArrayList*) _tmp80_;
			_tmp82_ = entry;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, &_tmp82_);
			_g_object_unref0 (_tmp81_);
			kkc_language_model_entry_destroy (&entry);
			input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp83_ = strv;
		_tmp83__length1 = strv_length1;
		_tmp84_ = _tmp83_[0];
		_tmp85_ = double_parse (_tmp84_);
		cost = _tmp85_;
		backoff = 0.0;
		_tmp86_ = strv;
		_tmp86__length1 = strv_length1;
		if (_tmp86__length1 > 2) {
			gchar** _tmp87_ = NULL;
			gint _tmp87__length1 = 0;
			const gchar* _tmp88_ = NULL;
			gdouble _tmp89_ = 0.0;
			_tmp87_ = strv;
			_tmp87__length1 = strv_length1;
			_tmp88_ = _tmp87_[2];
			_tmp89_ = double_parse (_tmp88_);
			backoff = _tmp89_;
		}
		_tmp90_ = strv;
		_tmp90__length1 = strv_length1;
		_tmp91_ = _tmp90_[1];
		_tmp93_ = _tmp92_ = g_strsplit (_tmp91_, " ", 0);
		words = _tmp93_;
		words_length1 = _vala_array_length (_tmp92_);
		_words_size_ = words_length1;
		_tmp94_ = g_new0 (guint, 0);
		ids = _tmp94_;
		ids_length1 = 0;
		_ids_size_ = ids_length1;
		_tmp95_ = words;
		_tmp95__length1 = words_length1;
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp95_;
			word_collection_length1 = _tmp95__length1;
			for (word_it = 0; word_it < _tmp95__length1; word_it = word_it + 1) {
				gchar* _tmp96_ = NULL;
				gchar* word = NULL;
				_tmp96_ = g_strdup (word_collection[word_it]);
				word = _tmp96_;
				{
					guint* _tmp97_ = NULL;
					gint _tmp97__length1 = 0;
					GeeMap* _tmp98_ = NULL;
					const gchar* _tmp99_ = NULL;
					gpointer _tmp100_ = NULL;
					_tmp97_ = ids;
					_tmp97__length1 = ids_length1;
					_tmp98_ = self->id_map;
					_tmp99_ = word;
					_tmp100_ = gee_map_get (_tmp98_, _tmp99_);
					_vala_array_add1 (&ids, &ids_length1, &_ids_size_, (guint) ((guintptr) _tmp100_));
					_g_free0 (word);
				}
			}
		}
		_tmp101_ = ids;
		_tmp101__length1 = ids_length1;
		_tmp102_ = kkc_text_bigram_language_model_get_key (self, _tmp101_, _tmp101__length1);
		key = _tmp102_;
		_tmp103_ = self->cost_map;
		_tmp104_ = key;
		_tmp105_ = cost;
		gee_map_set (_tmp103_, _tmp104_, &_tmp105_);
		_tmp106_ = self->backoff_map;
		_tmp107_ = key;
		_tmp108_ = backoff;
		gee_map_set (_tmp106_, _tmp107_, &_tmp108_);
		_g_free0 (key);
		ids = (g_free (ids), NULL);
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
	_g_object_unref0 (lm_data);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (lm_file);
}


static gboolean kkc_text_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error) {
	KkcTextBigramLanguageModel * self;
	gboolean result = FALSE;
	gchar* prefix = NULL;
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	KkcLanguageModelMetadata* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcTextBigramLanguageModel*) base;
	_tmp0_ = kkc_language_model_get_metadata ((KkcLanguageModel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = kkc_metadata_file_get_filename ((KkcMetadataFile*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_path_get_dirname (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp5_, "data", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	prefix = _tmp7_;
	_tmp8_ = g_strconcat (prefix, ".arpa", NULL);
	_tmp9_ = _tmp8_;
	kkc_text_bigram_language_model_parse_lm (self, _tmp9_, &_inner_error_);
	_g_free0 (_tmp9_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (prefix);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (prefix);
	return result;
}


KkcTextBigramLanguageModel* kkc_text_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error) {
	KkcTextBigramLanguageModel * self = NULL;
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	self = (KkcTextBigramLanguageModel*) kkc_language_model_construct (object_type, _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcTextBigramLanguageModel* kkc_text_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error) {
	return kkc_text_bigram_language_model_construct (KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, metadata, error);
}


static void kkc_text_bigram_language_model_real_get_bos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcTextBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_ = {0};
	self = (KkcTextBigramLanguageModel*) base;
	_tmp0_ = self->priv->_bos;
	*result = _tmp0_;
	return;
}


static void kkc_text_bigram_language_model_real_get_eos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcTextBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_ = {0};
	self = (KkcTextBigramLanguageModel*) base;
	_tmp0_ = self->priv->_eos;
	*result = _tmp0_;
	return;
}


static void kkc_text_bigram_language_model_class_init (KkcTextBigramLanguageModelClass * klass) {
	kkc_text_bigram_language_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcTextBigramLanguageModelPrivate));
	((KkcLanguageModelClass *) klass)->unigram_entries = kkc_text_bigram_language_model_real_unigram_entries;
	((KkcLanguageModelClass *) klass)->entries = kkc_text_bigram_language_model_real_entries;
	((KkcLanguageModelClass *) klass)->get = kkc_text_bigram_language_model_real_get;
	((KkcLanguageModelClass *) klass)->parse = kkc_text_bigram_language_model_real_parse;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_bos = kkc_text_bigram_language_model_real_get_bos;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_eos = kkc_text_bigram_language_model_real_get_eos;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_text_bigram_language_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_text_bigram_language_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_TEXT_BIGRAM_LANGUAGE_MODEL_BOS, g_param_spec_boxed ("bos", "bos", "bos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_TEXT_BIGRAM_LANGUAGE_MODEL_EOS, g_param_spec_boxed ("eos", "eos", "eos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_text_bigram_language_model_kkc_unigram_language_model_interface_init (KkcUnigramLanguageModelIface * iface) {
	kkc_text_bigram_language_model_kkc_unigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->unigram_cost = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_unigram_cost;
	iface->unigram_backoff = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_unigram_backoff;
}


static void kkc_text_bigram_language_model_kkc_bigram_language_model_interface_init (KkcBigramLanguageModelIface * iface) {
	kkc_text_bigram_language_model_kkc_bigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_bigram = (gboolean (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_has_bigram;
	iface->bigram_cost = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_bigram_cost;
	iface->bigram_backoff = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_text_bigram_language_model_real_bigram_backoff;
}


static void kkc_text_bigram_language_model_instance_init (KkcTextBigramLanguageModel * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	self->priv = KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->input_map = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->cost_map = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->backoff_map = (GeeMap*) _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->id_map = (GeeMap*) _tmp3_;
}


static void kkc_text_bigram_language_model_finalize (GObject* obj) {
	KkcTextBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel);
	kkc_language_model_entry_destroy (&self->priv->_bos);
	kkc_language_model_entry_destroy (&self->priv->_eos);
	_g_object_unref0 (self->input_map);
	_g_object_unref0 (self->cost_map);
	_g_object_unref0 (self->backoff_map);
	_g_object_unref0 (self->id_map);
	G_OBJECT_CLASS (kkc_text_bigram_language_model_parent_class)->finalize (obj);
}


GType kkc_text_bigram_language_model_get_type (void) {
	static volatile gsize kkc_text_bigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_text_bigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcTextBigramLanguageModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_text_bigram_language_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcTextBigramLanguageModel), 0, (GInstanceInitFunc) kkc_text_bigram_language_model_instance_init, NULL };
		static const GInterfaceInfo kkc_unigram_language_model_info = { (GInterfaceInitFunc) kkc_text_bigram_language_model_kkc_unigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_bigram_language_model_info = { (GInterfaceInitFunc) kkc_text_bigram_language_model_kkc_bigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_text_bigram_language_model_type_id;
		kkc_text_bigram_language_model_type_id = g_type_register_static (KKC_TYPE_LANGUAGE_MODEL, "KkcTextBigramLanguageModel", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_text_bigram_language_model_type_id, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, &kkc_unigram_language_model_info);
		g_type_add_interface_static (kkc_text_bigram_language_model_type_id, KKC_TYPE_BIGRAM_LANGUAGE_MODEL, &kkc_bigram_language_model_info);
		g_once_init_leave (&kkc_text_bigram_language_model_type_id__volatile, kkc_text_bigram_language_model_type_id);
	}
	return kkc_text_bigram_language_model_type_id__volatile;
}


static void _vala_kkc_text_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcTextBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel);
	switch (property_id) {
		case KKC_TEXT_BIGRAM_LANGUAGE_MODEL_BOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_bos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case KKC_TEXT_BIGRAM_LANGUAGE_MODEL_EOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_eos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



