/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  entry.cc - GtkEntry C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "entry.h"
#include "private/entry_p.h"
#include "private/editable_p.h"
#include "private/celleditable_p.h"
#include "menu.h"
#include "../glib/unicode.h"
#include "../pango/layout.h"

using namespace Inti;

/*  Gtk::Entry
 */

Gtk::Entry::Entry(GtkEntry *entry, bool reference)
: Widget((GtkWidget*)entry, reference)
{
}

Gtk::Entry::Entry() 
: Widget((GtkWidget*)EntryClass::create())
{
}

Gtk::Entry::Entry(int max_length) 
: Widget((GtkWidget*)EntryClass::create())
{
	set_max_length(max_length);
}

Gtk::Entry::~Entry()
{
}

GtkEntryClass*
Gtk::Entry::gtk_entry_class() const 
{ 
	return get_class<GtkEntryClass>(); 
}
	
Gtk::Entry::operator GtkEntry* () const 
{ 
	return this ? gtk_entry() : 0; 
}
	
String
Gtk::Entry::get_text() const
{
	return gtk_entry_get_text(gtk_entry());
}

bool
Gtk::Entry::get_visibility() const
{
	return gtk_entry_get_visibility(gtk_entry());
}

G::Unichar
Gtk::Entry::get_invisible_char() const
{
	return gtk_entry_get_invisible_char(gtk_entry());
}

bool
Gtk::Entry::get_has_frame() const
{
	return gtk_entry_get_has_frame(gtk_entry());
}

int
Gtk::Entry::get_max_length() const
{
	return gtk_entry_get_max_length(gtk_entry());
}

bool 
Gtk::Entry::get_activates_default() const
{
	return gtk_entry_get_activates_default(gtk_entry());
}

int
Gtk::Entry::get_width_chars() const
{
	return gtk_entry_get_width_chars(gtk_entry());
}

Pango::Layout*
Gtk::Entry::get_layout() const
{
	return G::Object::wrap<Pango::Layout>(gtk_entry_get_layout(gtk_entry()));
}

void 
Gtk::Entry::get_layout_offsets(int *x, int *y) const
{
	gtk_entry_get_layout_offsets(gtk_entry(), x, y);
}

void 
Gtk::Entry::set_visibility(bool visible)
{
	gtk_entry_set_visibility(gtk_entry(), visible);
}

void 
Gtk::Entry::set_invisible_char(G::Unichar ch)
{
	gtk_entry_set_invisible_char(gtk_entry(), ch);
}

void 
Gtk::Entry::set_has_frame(bool setting)
{
	gtk_entry_set_has_frame(gtk_entry(), setting);
}

void 
Gtk::Entry::set_max_length(int max)
{
	gtk_entry_set_max_length(gtk_entry(), max);
}

void 
Gtk::Entry::set_text(const String& text)
{
	gtk_entry_set_text(gtk_entry(), text.c_str());
}

void  
Gtk::Entry::set_activates_default(bool setting)
{
	gtk_entry_set_activates_default(gtk_entry(), setting);
}

void  
Gtk::Entry::set_width_chars(int n_chars)
{
	gtk_entry_set_width_chars(gtk_entry(), n_chars);
}

/*  Gtk::EntryClass
 */

void
Gtk::EntryClass::init(GtkEntryClass *g_class)
{
	WidgetClass::init((GtkWidgetClass*)g_class);
	g_class->populate_popup = &populate_popup_proxy;
	g_class->activate = &activate_proxy;
	g_class->insert_at_cursor = &insert_at_cursor_proxy;
}

GType
Gtk::EntryClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ENTRY, (GClassInitFunc)init);
		G::TypeInstance::add_interface(type, GTK_TYPE_EDITABLE, (GInterfaceInitFunc)EditableClass::init);
		G::TypeInstance::add_interface(type, GTK_TYPE_CELL_EDITABLE, (GInterfaceInitFunc)CellEditableIface::init);
	}
	return type;
}

void*
Gtk::EntryClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::EntryClass::populate_popup_proxy(GtkEntry *entry, GtkMenu *menu)
{
	Entry *tmp_entry = G::Object::pointer<Entry>(entry);
	if (tmp_entry)
		tmp_entry->on_populate_popup(*G::Object::wrap<Gtk::Menu>(menu));
	else
	{
		GtkEntryClass *g_class = G::TypeInstance::class_peek_parent<GtkEntryClass>(GTK_ENTRY_GET_CLASS(entry));
		if (g_class->populate_popup)
			g_class->populate_popup(entry, menu);
	}
}

void
Gtk::EntryClass::activate_proxy(GtkEntry *entry)
{
	Entry *tmp_entry = G::Object::pointer<Entry>(entry);
	if (tmp_entry)
		tmp_entry->on_activate();
	else
	{
		GtkEntryClass *g_class = G::TypeInstance::class_peek_parent<GtkEntryClass>(GTK_ENTRY_GET_CLASS(entry));
		if (g_class->activate)
			g_class->activate(entry);
	}
}

void
Gtk::EntryClass::insert_at_cursor_proxy(GtkEntry *entry, const gchar *str)
{
	Entry *tmp_entry = G::Object::pointer<Entry>(entry);
	if (tmp_entry)
	{
		std::string tmp_str(str);
		tmp_entry->on_insert_at_cursor(tmp_str);
	}
	else
	{
		GtkEntryClass *g_class = G::TypeInstance::class_peek_parent<GtkEntryClass>(GTK_ENTRY_GET_CLASS(entry));
		if (g_class->insert_at_cursor)
			g_class->insert_at_cursor(entry, str);
	}
}

/*  Signal handlers
 */

void
Gtk::Entry::on_populate_popup(Menu& menu)
{
	GtkEntryClass *g_class = class_peek_parent<GtkEntryClass>(gtk_entry_class());
	if (g_class->populate_popup)
		g_class->populate_popup(gtk_entry(), menu.gtk_menu());
}

void
Gtk::Entry::on_activate()
{
	GtkEntryClass *g_class = class_peek_parent<GtkEntryClass>(gtk_entry_class());
	if (g_class->activate)
		g_class->activate(gtk_entry());
}

void
Gtk::Entry::on_insert_at_cursor(const String& text)
{
	GtkEntryClass *g_class = class_peek_parent<GtkEntryClass>(gtk_entry_class());
	if (g_class->insert_at_cursor)
		g_class->insert_at_cursor(gtk_entry(), text.c_str());
}

/*  Properties
 */

const Gtk::Entry::CursorPositionPropertyType Gtk::Entry::cursor_position_property("cursor_position");

const Gtk::Entry::SelectionBoundPropertyType Gtk::Entry::selection_bound_property("selection_bound");

const Gtk::Entry::EditablePropertyType Gtk::Entry::editable_property("editable_property");

const Gtk::Entry::MaxLengthPropertyType Gtk::Entry::max_length_property("max_length");

const Gtk::Entry::VisibilityPropertyType Gtk::Entry::visibility_property("visibility");

const Gtk::Entry::HasFramePropertyType Gtk::Entry::has_frame_property("has_frame");

const Gtk::Entry::InvisibleCharPropertyType Gtk::Entry::invisible_char_property("invisible_char");

const Gtk::Entry::ActivatesDefaultPropertyType Gtk::Entry::activates_default_property("activates_default");

const Gtk::Entry::WidthCharsPropertyType Gtk::Entry::width_chars_property("width_chars");

const Gtk::Entry::ScrollOffsetPropertyType Gtk::Entry::scroll_offset_property("scroll_offset");

const Gtk::Entry::TextPropertyType Gtk::Entry::text_property("text");

/*  Signals
 */

const Gtk::Entry::PopulatePopupSignalType Gtk::Entry::populate_popup_signal("populate_popup");

const Gtk::Entry::ActviateSignalType Gtk::Entry::activate_signal("activate");

const Gtk::Entry::InsertAtCursorSignalType Gtk::Entry::insert_at_cursor_signal("insert_at_cursor");

