/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  combo.cc - GtkCombo C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "combo.h"
#include "private/combo_p.h"
#include "entry.h"
#include "button.h"
#include "scrolledwindow.h"
#include "window.h"
#include "item.h"

using namespace Inti;

/*  Gtk::Combo
 */

Gtk::Combo::Combo(GtkCombo *combo, bool reference)
: HBox((GtkHBox*)combo, reference)
{
}

Gtk::Combo::Combo() 
: HBox((GtkHBox*)ComboClass::create())
{
}

Gtk::Combo::~Combo() 
{
}
	
GtkComboClass* 
Gtk::Combo::gtk_combo_class() const 
{ 
	return get_class<GtkComboClass>(); 
}
	
Gtk::Combo::operator GtkCombo* () const 
{ 
	return this ? gtk_combo() : 0;
}
	
Gtk::Entry*
Gtk::Combo::entry() const
{
	return G::Object::wrap<Entry>((GtkEntry*)gtk_combo()->entry);
}	

Gtk::Widget*
Gtk::Combo::list() const
{
	return G::Object::wrap<Widget>(gtk_combo()->list);
}	

void 
Gtk::Combo::set_value_in_list(bool value_in_list, bool ok_if_empty)
{
	gtk_combo_set_value_in_list(gtk_combo(), value_in_list, ok_if_empty);
}

void 
Gtk::Combo::set_use_arrows(bool use_arrows)
{
	gtk_combo_set_use_arrows(gtk_combo(), use_arrows);
}
	
void 
Gtk::Combo::set_use_arrows_always(bool use_arrows_always)
{
	gtk_combo_set_use_arrows_always(gtk_combo(), use_arrows_always);
}

void 
Gtk::Combo::set_case_sensitive(bool case_sensitive)
{
	gtk_combo_set_case_sensitive(gtk_combo(), case_sensitive);
}

void 
Gtk::Combo::set_item_string(Item& item, const String& item_value)
{
	gtk_combo_set_item_string(gtk_combo(), item.gtk_item(), item_value.c_str());
}

void 
Gtk::Combo::set_popdown_strings(const std::vector<String>& strings)
{
	g_return_if_fail(!strings.empty());
	GList *tmp_strings = 0;
	int count = strings.size();
	
	int i = 0;
	while (i < count)
	{
		tmp_strings = g_list_append(tmp_strings, (void*)strings[i].c_str());
		++i;
	}
		
	gtk_combo_set_popdown_strings(gtk_combo(), tmp_strings);
	g_list_free(tmp_strings);
}

void 
Gtk::Combo::disable_activate()
{
	gtk_combo_disable_activate(gtk_combo());
}

/*  Gtk::ComboClass
 */

void
Gtk::ComboClass::init(GtkComboClass *g_class)
{
	HBoxClass::init((GtkHBoxClass*)g_class);
}

GType
Gtk::ComboClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_COMBO, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ComboClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::Combo::EnableArrowKeysPropertyType Gtk::Combo::enable_arrow_keys_property("enable_arrow_keys");


const Gtk::Combo::EnableArrowsAlwaysPropertyType Gtk::Combo::enable_arrows_always_property("enable_arrows_always");


const Gtk::Combo::CaseSensitivePropertyType Gtk::Combo::case_sensitive_property("case_sensitive");


const Gtk::Combo::AllowEmptyPropertyType Gtk::Combo::allow_empty_property("allow_empty");


const Gtk::Combo::ValueInListPropertyType Gtk::Combo::value_in_list_property("value_in_list");

