/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  rand.cc - A C++ interface for GRand.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "rand.h"

using namespace Inti;

/*  G::random_set_seed
 */

void
G::random_set_seed(unsigned int seed)
{
	g_random_set_seed(seed);
}

/*  G::random_boolean
 */

bool
G::random_boolean()
{
	return g_random_boolean();
}

/*  G::random_int
 */

unsigned int
G::random_int()
{
	return g_random_int();
}

/*  G::random_int_range
 */

int
G::random_int_range(int begin, int end)
{
	return g_random_int_range(begin, end);
}

/*  G::random_double
 */

double
G::random_double()
{
	return g_random_double();
}

/*  G::random_double_range
 */

double
G::random_double_range(double begin, double end)
{
	return g_random_double_range(begin, end);
}

/*  G::Rand
 */

G::Rand::Rand()
: rand_(g_rand_new())
{
}

G::Rand::Rand(unsigned int seed)
: rand_(g_rand_new_with_seed(seed))
{
}

G::Rand::~Rand()
{
	if (rand_)
	{
		g_rand_free(rand_);
		rand_ = 0;
	}
}

G::Rand::operator GRand* () const
{
	return this ? g_rand() : 0;
}

bool
G::Rand::get_bool() const
{
	return g_rand_boolean(rand_);
}

unsigned int
G::Rand::get_int() const
{
	return g_rand_int(rand_);
}

int
G::Rand::get_int_range(int begin, int end) const
{
	g_rand_int_range(rand_, begin, end);
}

double
G::Rand::get_double() const
{
	return g_rand_double(rand_);
}

double
G::Rand::get_double_range(double begin, double end) const
{
	return g_rand_double_range(rand_, begin, end);
}

void
G::Rand::set_seed(unsigned int seed)
{
	g_rand_set_seed(rand_, seed);
}

