/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/atk/hypertext.h
//! @brief An AtkHypertext C++ wrapper interface.
//!
//! Provides Hypertext, an interface which provides a standard mechanism for manipulating hyperlinks.

#ifndef INTI_ATK_HYPERTEXT_H
#define INTI_ATK_HYPERTEXT_H

#ifndef INTI_G_TYPE_H
#include <inti/glib/type.h>
#endif

#ifndef __ATK_HYPERTEXT_H__
#include <atk/atkhypertext.h>
#endif

namespace Inti {

namespace Atk {

class Hyperlink;
class HypertextIface;

//! @class Hypertext hypertext.h inti/atk/hypertext.h
//! @brief An AtkHypertext C++ wrapper class.
//!
//! Hypertext is an interface which provides a standard mechanism for manipulating hyperlinks.

class Hypertext : public virtual G::TypeInterface
{
	friend class HypertextIface;

protected:
//! @name Constructors
//! @{

	virtual ~Hypertext() = 0;
	//!< Destructor.

//! @}
//  Override these do_ methods when you want to change the default behaviour of the AtkHypertext.

	virtual AtkHyperlink* do_get_link(int link_index);

	virtual int do_get_n_links();

	virtual int do_get_link_index(int char_index);

public:
//! @name Accessors
//! @{

	AtkHypertext* atk_hypertext() const { return (AtkHypertext*)instance; }
	//!< Get a pointer to the AtkHypertext structure.

	AtkHypertextIface* atk_hypertext_iface() const;
	//!< Get a pointer to the AtkHypertextIface structure.

	operator AtkHypertext* () const;
	//!< Conversion operator; safely converts a Hypertext to an AtkHypertext pointer.

	Hyperlink* get_link(int link_index) const;
	//!< Gets the link in this hypertext document at index <EM>link_index</EM>.
	//!< @param link_index An integer specifying the desired link.
	//!< @return The link in this hypertext document at index <EM>link_index</EM>.

	int get_n_links(int char_index) const;
	//!< Returns the number of links within this hypertext document.

	int get_link_index(int char_index) const;
	//!< Gets the index into the array of hyperlinks that is associated with the
	//!< character specified by <EM>char_index</EM>, or -1 if there is no hyperlink
	//!< associated with this character.
	//!< @param char_index A character index.
	//!< @return An index into the array of hyperlinks in the hypertext.

//! @}
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_HYPERTEXT_H

