/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: FileDemoPanel.java,v 1.7 2006/02/26 00:59:08 pietschy Exp $
 */

package org.pietschy.command.demo.file;

import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandHyperlinkListener;
import org.pietschy.command.CommandManager;
import org.pietschy.command.demo.DemoPanel;
import org.pietschy.command.file.AbstractFileOpenCommand;
import org.pietschy.command.file.AbstractSaveAsCommand;
import org.pietschy.command.file.ExtensionFileFilter;

import javax.swing.*;
import java.awt.*;
import java.io.*;

public class
FileDemoPanel
extends DemoPanel
{
   static final String _ID_ = "$Id: FileDemoPanel.java,v 1.7 2006/02/26 00:59:08 pietschy Exp $";

   private CommandGroup[] menus;
   private JTextPane textPane;
   private RecentFileGroup recent;
   private AbstractFileOpenCommand fileOpen;
   private AbstractSaveAsCommand saveAs;

   public FileDemoPanel()
   {
      super("File Examples", "file-page.selector", "file-commands.xml");

      initCommands();

      HTMLPane html = new HTMLPane();
      try
      {
         html.setPage(getClass().getResource("file.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load welcome.html", e);
      }
      html.addHyperlinkListener(new CommandHyperlinkListener());

      setLayout(new BorderLayout());
      add(new JScrollPane(html), BorderLayout.CENTER);
   }


   public void
   initCommands()
   {
      CommandManager cm = CommandManager.defaultInstance();

      textPane = new JTextPane();
      textPane.setEditable(false);

      ExtensionFileFilter[] filters =
      {
         new ExtensionFileFilter("txt", "*.txt"),
         new ExtensionFileFilter("xml", "*.xml"),
      };
      fileOpen = new AbstractFileOpenCommand("file-page.open", filters)
      {
         {
            setAcceptAllFileFilterUsed(true);
            setMultiselectionEnabled(false);
            setRememberLastFilter(true);
            setCenterOnInvoker(false);
         }

         protected void
         performOpen(File[] files)
         {
            // we only have single selection enabled.
           JOptionPane.showMessageDialog(FileDemoPanel.this, "You've chosen to open \"" + files[0].getName() + "\"");
            recent.add(files[0]);
         }
      };
      fileOpen.export();

      saveAs = new AbstractSaveAsCommand("file-page.save-as", filters)
      {
         {
            setAcceptAllFileFilterUsed(false);
            setCenterOnInvoker(false);
         }

         protected void
         performSave(File file)
         {
            JOptionPane.showMessageDialog(FileDemoPanel.this, "<html>Normally I'd be saving the file to \"<b>" + file.getName() + "</b>\", but since it's a demo I'll skip it</html>");
            recent.add(file);
         }
      };
      saveAs.export();

      // see if the command manager will instantiate the correct class...
      recent = (RecentFileGroup) CommandManager.defaultInstance().getGroup("file-page.recent-files");
      recent.setFileDemoPanel(this);
      recent.getClearCommand().setVisible(true);

      menus = new CommandGroup[]{cm.getGroup("file-page.menu")};

//      TableBuilder builder = new TableBuilder();
//      builder.rows().defaultPaddingTop(builder.layoutStyle().unrelatedRowGap());
//      builder.row(0).paddingTop(0);
//      int row = 0;
//
//      builder.addXY(new JScrollPane(textPane), 0, row)
//      .fillX().fillY()
//      .minimumWidth(0);
//      builder.firstColumn().grow(1.0);
//      builder.row(0).grow(1.0);
//
//      builder.margin(builder.layoutStyle().tabbedDialogMargin());
//      builder.buildLayout();
//
//      return builder.getPanel();
   }

   protected void openFile(File file)
   {
      FileReader fileReader = null;
      LineNumberReader lineReader = null;

      try
      {
         fileReader = new FileReader(file);
         lineReader = new LineNumberReader(fileReader);

         StringWriter sw = new StringWriter();
         PrintWriter pw = new PrintWriter(sw);
         String line;
         while ((line = lineReader.readLine()) != null)
         {
            pw.println(line);
         }

         textPane.setText(sw.toString());
         textPane.setCaretPosition(0);
      }
      catch (IOException e)
      {
         JOptionPane.showMessageDialog(this, "Error opening " + file.getAbsolutePath());
      }
      finally
      {
         if (lineReader != null)
            try
            {
               lineReader.close();
            }
            catch (IOException e)
            {
               if (fileReader != null)
                  try
                  {
                     fileReader.close();
                  }
                  catch (IOException e1)
                  {
                  }
            }
      }
   }

   public CommandGroup[]
   getMenuGroups()
   {
      return menus;
   }

   public CommandGroup
   getToolbarGroup()
   {
      return null;//menus[0];
   }

}
