package org.pietschy.command;

/**
 * Created by IntelliJ IDEA.
 * User: andrew
 * Date: Oct 12, 2005
 * Time: 4:07:03 PM
 * To change this template use File | Settings | File Templates.
 */
class
IdHelper
{

   private static final String ANONYMOUS_ID_PREFIX = "org.pietschy.command.$$anonymous_command$$";

   private static int anonymousCount = 0;

   /**
    * Creates an anonymous id string.
    *
    * @return an anonymous id string.
    */
   protected static String
   createAnonymousId()
   {
      return ANONYMOUS_ID_PREFIX + Integer.toString(anonymousCount++);
   }


   /**
    * Checks if this is an anonymous command.  Anonymous commands have no id, and can't be
    * exported or configured by the {@link CommandManager}.  They are useful when you need
    * to programatically create a command.
    * <p/>
    * All commands created without an id are anonymous.
    *
    * @return <tt>true</tt> if this command is anonymous, <tt>false</tt> otherwise.
    */
   public static boolean
   isAnonymous(String id)
   {
      return id.startsWith(ANONYMOUS_ID_PREFIX);
   }
}
