/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ExpansionMember.java,v 1.12 2006/02/26 00:59:05 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

class
ExpansionMember
extends AbstractGroupMember
implements ExpansionGroupMember
{
   static final String _ID_ = "$Id: ExpansionMember.java,v 1.12 2006/02/26 00:59:05 pietschy Exp $";

   private LinkedHashSet members = new LinkedHashSet();
   private String name;
   private boolean separatorBefore = false;
   private boolean separatorAfter = false;

   protected ExpansionMember(String name)
   {
      this.name = name;
   }

   public boolean isSeparatorBefore()
   {
      return separatorBefore;
   }

   public void setSeparatorBefore(boolean separatorBefore)
   {
      this.separatorBefore = separatorBefore;
   }

   public boolean isSeparatorAfter()
   {
      return separatorAfter;
   }

   public void setSeparatorAfter(boolean separatorAfter)
   {
      this.separatorAfter = separatorAfter;
   }

   public String getName()
   {
      return name;
   }

   public void add(GroupMember member)
   {
      if (members.add(member))
      {
         member.addNotify();
      }
   }

   public void remove(GroupMember member)
   {
      if (members.remove(member))
      {
         member.removeNotify();
      }
   }

   public int
   size()
   {
      return members.size();
   }

   public GroupMember getMemberFor(Command command)
   {
      for (Iterator iterator = members.iterator(); iterator.hasNext();)
      {
         GroupMember member = (GroupMember) iterator.next();
         if (member.isMemberFor(command))
            return member;
      }

      return null;
   }


   public void clear()
   {
      members.clear();
   }

   public void addComponentTo(JComponent parent, Object factory, String faceId, List previousButtons, int buttonIndex)
   {
      if (members.size() > 0 && isSeparatorBefore())
         addSeparator(parent);

      int index = 0;
      for (Iterator iterator = members.iterator(); iterator.hasNext();)
      {
         GroupMember delegate = (GroupMember) iterator.next();
         delegate.addComponentTo(parent, factory, faceId, previousButtons, index++);
      }

      if (members.size() > 0 && isSeparatorAfter())
         addSeparator(parent);
   }

   public boolean isMemberFor(Command c)
   {
      for (Iterator iterator = members.iterator(); iterator.hasNext();)
      {
         GroupMember member = (GroupMember) iterator.next();
         if (member.isMemberFor(c))
            return true;
      }

      return false;
   }

   public boolean isDependantOn(Command command)
   {
      for (Iterator iterator = members.iterator(); iterator.hasNext();)
      {
         GroupMember member = (GroupMember) iterator.next();
         if (member.isDependantOn(command))
            return true;
      }

      return false;
   }

   public void acceptVisitor(GroupVisitor visitor)
   {
      for (Iterator iterator = members.iterator(); iterator.hasNext();)
      {
         GroupMember member = (GroupMember) iterator.next();
         member.acceptVisitor(visitor);
      }
   }

   public boolean isPermenant()
   {
      return true;
   }

   public boolean isEmpty()
   {
      return members.isEmpty();
   }

}
