/**
 * @file libgnurdf/iterator.h Iterator functions
 *
 * $Id: iterator.h,v 1.4 2001/09/20 20:00:48 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBGNURDF_ITERATOR_H_
#define _LIBGNURDF_ITERATOR_H_

#include <libgnurdf/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Returns the first property in a container.
 *
 * @param container The container containing the properties.
 *
 * @return The first property in \a container.
 */
RdfElement *rdfFirstProperty(RdfContainer *container);

/**
 * Returns the next property in a container.
 *
 * @param element The previous element in the container.
 *
 * @return The next property in the container.
 */
RdfElement *rdfNextProperty(RdfElement *element);


/*************************************************************************/
/** @name Backwards-compatibility functions                              */
/*************************************************************************/
/*@{*/

/**
 * Returns the first property in a container.
 *
 * @deprecated This function has been replaced with rdfFirstProperty()
 *
 * @see rdfFirstProperty()
 */
RdfElement *rdfFirstChild(RdfContainer *container);

/**
 * Returns the next property in a container.
 *
 * @deprecated This function has been replaced with rdfNextProperty()
 *
 * @see rdfNextProperty()
 */
RdfElement *rdfNextChild(RdfContainer *container);

/*@}*/


#ifdef __cplusplus
}
#endif

#endif /* _LIBGNURDF_ITERATOR_H_ */

