/* -*- c-file-style: "ruby"; tab-width: 4 -*-
 *
 * Copyright (C) 2002,2003 Masao Mutoh <mutoh@highway.ne.jp>
 * 
 * You may redistribute it and/or modify it under the same
 * license terms as Ruby.
 * 
 * $Id: _locale.c,v 1.8 2003/11/11 19:04:30 mutoh Exp $
 */

#include "ruby.h"

VALUE mLocale;

#if defined HAVE_WINDOWS_H
# include <windows.h>
#else
# if defined HAVE_SETLOCALE
#  include <locale.h>
# endif
# if defined HAVE_NL_LANGINFO
#  include <langinfo.h>
# endif
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#if defined HAVE_WINDOWS_H
static VALUE
gt_locale_id_win32(self)
    VALUE self;
{
	int lcid, pri_id, sub_id;
	lcid = GetUserDefaultLangID();
	pri_id = lcid & 0x3ff;
	sub_id = lcid >> 10;
	return rb_assoc_new(INT2FIX(pri_id), INT2FIX(sub_id));
}
#endif
static VALUE
gt_setlocale(self, type, locale)
    VALUE self, type, locale;
{
# if defined HAVE_SETLOCALE
    char* ret = setlocale(NUM2INT(type), 
			  NIL_P(locale) ? "" : StringValuePtr(locale));
    return ret == NULL ? rb_str_new2("C") : rb_str_new2(ret);
# else
    return rb_str_new2("C");
# endif
}

static VALUE
gt_codeset(self)
	VALUE self;
{
#if defined HAVE_WINDOWS_H
	char buf[2 + 10 + 1];
	sprintf (buf, "CP%u", GetACP ());
	return rb_str_new2(buf);
#elif defined HAVE_NL_LANGINFO
# if defined HAVE_SETLOCALE
	setlocale(LC_ALL, "");
	setlocale(LC_NUMERIC, "C");
# endif
	return rb_str_new2(nl_langinfo(CODESET));
#else
	return rb_str_new2("UTF-8");
#endif
}

void Init__locale()
{
    mLocale = rb_define_module("Locale");

#if defined HAVE_WINDOWS_H
    rb_define_module_function(mLocale, "__locale_id", gt_locale_id_win32, 0);
#endif
    rb_define_module_function(mLocale, "set", gt_setlocale, 2);
    rb_define_module_function(mLocale, "codeset", gt_codeset, 0);
# if defined HAVE_SETLOCALE
    rb_define_const(mLocale, "ALL", INT2NUM(LC_ALL));
    rb_define_const(mLocale, "COLLATE", INT2NUM(LC_COLLATE));
    rb_define_const(mLocale, "CTYPE", INT2NUM(LC_CTYPE));
    rb_define_const(mLocale, "MESSAGES", INT2NUM(LC_MESSAGES));
    rb_define_const(mLocale, "MONETARY", INT2NUM(LC_MONETARY));
    rb_define_const(mLocale, "NUMERIC", INT2NUM(LC_NUMERIC));
    rb_define_const(mLocale, "TIME", INT2NUM(LC_TIME));
#endif

}
