/*******************************************************************************************************************************************
 cexception.h
 Exception definition. The exception instance should be allocated with the new operator. 
*******************************************************************************************************************************************/

#ifndef __CEXCEPTION_H__
#define __CEXCEPTION_H__

// just for prototypes indications
#define THROWABLE

#include "cclass.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// exception notation
//------------------------------------------------------------------------------------------------------------------------------------------

// exception code type
typedef UInt32 TException;

// exception code access
#define __exception(name) EXCEPTION_##name

// exception declaration macro
#define DECLARE_EXCEPTION(name,id) const static TException __exception(name)  = (TException) id;

// some default values
DECLARE_EXCEPTION (NOTDEFINED, 	  0L);	// no error code
DECLARE_EXCEPTION (NULLPARAMETER, 1L);	// null parameter
DECLARE_EXCEPTION (BADPARAMETER,  2L);	// wrong parameter

//------------------------------------------------------------------------------------------------------------------------------------------
// CException class
//------------------------------------------------------------------------------------------------------------------------------------------
class CException : public CClass
{
	// instanciation section
	public :

		CException			(const CString &inMessage, const TException inErrorCode=__exception(NOTDEFINED));
		virtual ~CException		();

	// general functions
	public :

		// the exception message, its error code
		CString				GetMessage	() const;
		TException			GetErrorCode	() const;

	// protected section
	protected :

		// message, code
		CString				m_Message;
		TException			m_ErrorCode;

		// metaclass section
		SECTION_CAPSULE_METACLASS;
};

// metaclass and class tag declaration
DECLARE_CAPSULE_METACLASS ('xpcn', CException, CClass);

#endif
