/**
 * @file test-chooser.c Chooser test app
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgalago-gtk/galago-gtk.h>

static GtkWidget *main_window;
static GtkWidget *contact_list;
static GtkWidget *remove_button;

static void
response_cb(GalagoGtkContactChooser *chooser, int response_id, gpointer data)
{
	if (response_id == GTK_RESPONSE_ACCEPT)
	{
		galago_gtk_contact_list_add_contact(
			GALAGO_GTK_CONTACT_LIST(contact_list),
			galago_gtk_contact_chooser_get_contact(chooser));
	}

	gtk_widget_destroy(GTK_WIDGET(chooser));
}

static void
add_clicked_cb(void)
{
	GtkWidget *dialog;

	dialog = galago_gtk_contact_chooser_dialog_new(
		"Select a Contact", GTK_WINDOW(main_window),
		GALAGO_GTK_CONTACT_CHOOSER_SELECT_CONTACTS,
		GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
		GTK_STOCK_ADD, GTK_RESPONSE_ACCEPT,
		NULL);
	gtk_widget_show(dialog);

	g_signal_connect(G_OBJECT(dialog), "response",
					 G_CALLBACK(response_cb), NULL);
}

int
main(int argc, char **argv)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *bbox;
	GtkWidget *add_button;
	GtkWidget *sw;

	gtk_init(&argc, &argv);

	if (!galago_init("test-chooser", FALSE))
		exit(1);

	main_window = window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_show(window);
	gtk_window_set_title(GTK_WINDOW(window), "Galago Chooser Test");
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width(GTK_CONTAINER(window), 12);

	g_signal_connect(G_OBJECT(window), "destroy",
					 G_CALLBACK(gtk_main_quit), NULL);

	vbox = gtk_vbox_new(FALSE, 6);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(sw);
	gtk_box_pack_start(GTK_BOX(vbox), sw, TRUE, TRUE, 0);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(sw),
										GTK_SHADOW_IN);

	contact_list = galago_gtk_contact_list_new(FALSE);
	gtk_widget_show(contact_list);
	gtk_container_add(GTK_CONTAINER(sw), contact_list);

	bbox = gtk_hbutton_box_new();
	gtk_widget_show(bbox);
	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, TRUE, 0);
	gtk_box_set_spacing(GTK_BOX(bbox), 6);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);

	add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
	gtk_widget_show(add_button);
	gtk_box_pack_start(GTK_BOX(bbox), add_button, FALSE, FALSE, 0);

	g_signal_connect(G_OBJECT(add_button), "clicked",
					 G_CALLBACK(add_clicked_cb), NULL);

	remove_button = gtk_button_new_from_stock(GTK_STOCK_REMOVE);
	gtk_widget_show(remove_button);
	gtk_box_pack_start(GTK_BOX(bbox), remove_button, FALSE, FALSE, 0);

	gtk_main();

	return 0;
}
