/**
 * @file libgalago-gtk/galago-gtk-account-label.h Account label widget
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_ACCOUNT_LABEL_H_
#define _GALAGO_GTK_ACCOUNT_LABEL_H_

typedef struct _GalagoGtkAccountLabel      GalagoGtkAccountLabel;
typedef struct _GalagoGtkAccountLabelClass GalagoGtkAccountLabelClass;
typedef struct _GalagoGtkAccountLabelPriv  GalagoGtkAccountLabelPriv;

#include <libgalago/galago.h>
#include <gtk/gtklabel.h>

#define GALAGO_GTK_TYPE_ACCOUNT_LABEL (galago_gtk_account_label_get_type())
#define GALAGO_GTK_ACCOUNT_LABEL(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_ACCOUNT_LABEL, GalagoGtkAccountLabel))
#define GALAGO_GTK_ACCOUNT_LABEL_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_ACCOUNT_LABEL, GalagoGtkAccountLabelClass))
#define GALAGO_GTK_IS_ACCOUNT_LABEL(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_ACCOUNT_LABEL))
#define GALAGO_GTK_IS_ACCOUNT_LABEL_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_ACCOUNT_LABEL))
#define GALAGO_GTK_ACCOUNT_LABEL_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_ACCOUNT_LABEL, GalagoGtkAccountLabelClass))

struct _GalagoGtkAccountLabel
{
	GtkLabel parent_object;

	GalagoGtkAccountLabelPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkAccountLabelClass
{
	GtkLabelClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_account_label_get_type(void);

GtkWidget *galago_gtk_account_label_new(void);

void galago_gtk_account_label_set_account(GalagoGtkAccountLabel *label,
										  GalagoAccount *account);

GalagoAccount *galago_gtk_account_label_get_account(const GalagoGtkAccountLabel *label);

G_END_DECLS

#endif /* _GALAGO_GTK_ACCOUNT_LABEL_H_ */
