/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

/* Converts two spaces at line's beginning to one tab, stdin to stdout. */

#include <stdio.h>


int main(int argc, char *argv[])
{
  char buf[4096];
  char *buf_ptr;
  
  for (;;)
  {
    fgets(buf, 4095, stdin);
    if (feof(stdin)) break;
    buf_ptr = buf;

    for (; *buf_ptr; buf_ptr++)
    {
      if (*buf_ptr == 0x09)
      {
        fputc(' ', stdout);
        fputc(' ', stdout);
      }
      else fputc(*buf_ptr, stdout);
    }
  }
  
  return(0);
}
