/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdlib.h>
#include "tn.h"


/* Edge array limits */

unsigned int edges_step_max[] =
{
  1, 2, 4, 8, 16, 32, 64, 192, 256, 512, 1024, 4096, 8192, 16384, 32768,
  65536, 131072, 262144, 524288, 1048576, 2097152, 4194304, 8388608
};

unsigned int edges_step_min[] =
{
  0, 1, 2, 4, 8,  16, 32,  96, 128, 256,  512, 2048, 4096,  8192, 16384,
  32768,  65536, 131072, 262144,  524288, 1048576, 2097152, 4194304
};


/* Functions */

/* --- Check edges --- */

long tn_edge_in_check(TN *a, TN *b)
{
  unsigned long i;
  TN **edge = a->edge_in;

  for (i = 0; i < a->edges_in_num; i++)
    if (edge[i] == b) return(i);

  return(-1);
}

long tn_edge_out_check(TN *a, TN *b)
{
  unsigned long i;
  TN **edge = a->edge_out;
  
  for (i = 0; i < a->edges_out_num; i++)
    if (edge[i] == b) return(i);

  return(-1);
}

/* --- Add edges --- */

void tn_edge_in_add(TN *a, TN *b)
{
  if ((a->edges_in_num + 1) > edges_step_max[a->edges_in_step])
    _tn_edges_step_set_in(a, a->edges_in_step + 1);

  a->edge_in[a->edges_in_num] = b;
  a->edges_in_num++;
}

void tn_edge_out_add(TN *a, TN *b)
{
  if ((a->edges_out_num + 1) > edges_step_max[a->edges_out_step])
    _tn_edges_step_set_out(a, a->edges_out_step + 1);

  a->edge_out[a->edges_out_num] = b;
  a->edges_out_num++;
}

/* --- Delete edges --- */

int tn_edge_in_del(TN *a, TN *b)
{
  unsigned long i;
  TN **edge = a->edge_in;

  for (i = 0; i < a->edges_in_num; i++)
    if (edge[i] == b)
    {
      edge[i] = 0;
      break;
    }
  
  if (i == a->edges_in_num) return(0);
  if (!tn_nopk(a)) tn_edges_in_pack(a);
  return(1);
}

int tn_edge_out_del(TN *a, TN *b)
{
  unsigned long i;
  TN **edge = a->edge_out;
  
  for (i = 0; i < a->edges_out_num; i++)
    if (edge[i] == b)
    {
      edge[i] = 0;
      break;
    }

  if (i == a->edges_out_num) return(0);
  if (!tn_nopk(a)) tn_edges_out_pack(a);
  return(1);
}

/* --- Pack edge lists --- */

void tn_edges_in_pack(TN *n)
{
  long i, j, k;
  TN **edge;

  /* Pack edge lists and count actual edges */
  
  for (i = j = 0, k = n->edges_in_num, edge = n->edge_in; j < k; j++)
  {
    if (!edge[j]) continue;
    edge[i++] = edge[j];
  }
  
  n->edges_in_num = i;

  /* Readjust edge list allocation if appropriate */

  for (i = n->edges_in_step; n->edges_in_num < edges_step_min[i]; i--) ;
  if (i != n->edges_in_step) _tn_edges_step_set_in(n, i);
}

void tn_edges_out_pack(TN *n)
{
  long i, j, k;
  TN **edge;

  /* Pack edge lists and count actual edges */

  for (i = j = 0, k = n->edges_out_num, edge = n->edge_out; j < k; j++)
  {
    if (!edge[j]) continue;
    edge[i++] = edge[j];
  }

  n->edges_out_num = i;

  /* Readjust edge list allocation if appropriate */

  for (i = n->edges_out_step; n->edges_out_num < edges_step_min[i]; i--) ;
  if (i != n->edges_out_step) _tn_edges_step_set_out(n, i);
}
