/* vfs-bookmarks-gtk.c generated by valac, the Vala compiler
 * generated from vfs-bookmarks-gtk.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS GTK+ Bookmarks Parser.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * Based on the code from the Awn Places applet, author Rodney Cryderman
 * <rcryderman@gmail.com>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK (desktop_agnostic_vfs_bookmark_get_type ())
#define DESKTOP_AGNOSTIC_VFS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK, DesktopAgnosticVFSBookmark))
#define DESKTOP_AGNOSTIC_VFS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK, DesktopAgnosticVFSBookmarkClass))
#define DESKTOP_AGNOSTIC_VFS_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK))
#define DESKTOP_AGNOSTIC_VFS_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK))
#define DESKTOP_AGNOSTIC_VFS_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK, DesktopAgnosticVFSBookmarkClass))

typedef struct _DesktopAgnosticVFSBookmark DesktopAgnosticVFSBookmark;
typedef struct _DesktopAgnosticVFSBookmarkClass DesktopAgnosticVFSBookmarkClass;
typedef struct _DesktopAgnosticVFSBookmarkPrivate DesktopAgnosticVFSBookmarkPrivate;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE (desktop_agnostic_vfs_file_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFile))
#define DESKTOP_AGNOSTIC_VFS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))

typedef struct _DesktopAgnosticVFSFile DesktopAgnosticVFSFile;
typedef struct _DesktopAgnosticVFSFileClass DesktopAgnosticVFSFileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS (desktop_agnostic_vfs_gtk_bookmarks_get_type ())
#define DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS, DesktopAgnosticVFSGtkBookmarks))
#define DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS, DesktopAgnosticVFSGtkBookmarksClass))
#define DESKTOP_AGNOSTIC_VFS_IS_GTK_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS))
#define DESKTOP_AGNOSTIC_VFS_IS_GTK_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS))
#define DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS, DesktopAgnosticVFSGtkBookmarksClass))

typedef struct _DesktopAgnosticVFSGtkBookmarks DesktopAgnosticVFSGtkBookmarks;
typedef struct _DesktopAgnosticVFSGtkBookmarksClass DesktopAgnosticVFSGtkBookmarksClass;
typedef struct _DesktopAgnosticVFSGtkBookmarksPrivate DesktopAgnosticVFSGtkBookmarksPrivate;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR (desktop_agnostic_vfs_file_monitor_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR, DesktopAgnosticVFSFileMonitor))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR, DesktopAgnosticVFSFileMonitorIface))

typedef struct _DesktopAgnosticVFSFileMonitor DesktopAgnosticVFSFileMonitor;
typedef struct _DesktopAgnosticVFSFileMonitorIface DesktopAgnosticVFSFileMonitorIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_EVENT (desktop_agnostic_vfs_file_monitor_event_get_type ())
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopAgnosticVFSBookmark {
	GObject parent_instance;
	DesktopAgnosticVFSBookmarkPrivate * priv;
};

struct _DesktopAgnosticVFSBookmarkClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSBookmarkPrivate {
	DesktopAgnosticVFSFile* _file;
	char* _alias;
};

struct _DesktopAgnosticVFSGtkBookmarks {
	GObject parent_instance;
	DesktopAgnosticVFSGtkBookmarksPrivate * priv;
};

struct _DesktopAgnosticVFSGtkBookmarksClass {
	GObjectClass parent_class;
};

typedef enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_UNKNOWN = 0,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED
} DesktopAgnosticVFSFileMonitorEvent;

struct _DesktopAgnosticVFSFileMonitorIface {
	GTypeInterface parent_iface;
	void (*emit) (DesktopAgnosticVFSFileMonitor* self, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event);
	gboolean (*cancel) (DesktopAgnosticVFSFileMonitor* self);
	gboolean (*get_cancelled) (DesktopAgnosticVFSFileMonitor* self);
};

struct _DesktopAgnosticVFSGtkBookmarksPrivate {
	DesktopAgnosticVFSFile* _file;
	DesktopAgnosticVFSFileMonitor* _monitor;
	GSList* _bookmarks;
};


static gpointer desktop_agnostic_vfs_bookmark_parent_class = NULL;
static gpointer desktop_agnostic_vfs_gtk_bookmarks_parent_class = NULL;

GType desktop_agnostic_vfs_bookmark_get_type (void);
GType desktop_agnostic_vfs_file_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_BOOKMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK, DesktopAgnosticVFSBookmarkPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_BOOKMARK_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_BOOKMARK_FILE,
	DESKTOP_AGNOSTIC_VFS_BOOKMARK_ALIAS
};
DesktopAgnosticVFSBookmark* desktop_agnostic_vfs_bookmark_new (void);
DesktopAgnosticVFSBookmark* desktop_agnostic_vfs_bookmark_construct (GType object_type);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_bookmark_get_file (DesktopAgnosticVFSBookmark* self);
void desktop_agnostic_vfs_bookmark_set_file (DesktopAgnosticVFSBookmark* self, DesktopAgnosticVFSFile* value);
const char* desktop_agnostic_vfs_bookmark_get_alias (DesktopAgnosticVFSBookmark* self);
void desktop_agnostic_vfs_bookmark_set_alias (DesktopAgnosticVFSBookmark* self, const char* value);
static void desktop_agnostic_vfs_bookmark_finalize (GObject* obj);
static void desktop_agnostic_vfs_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_vfs_gtk_bookmarks_get_type (void);
GType desktop_agnostic_vfs_file_monitor_event_get_type (void);
GType desktop_agnostic_vfs_file_monitor_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS, DesktopAgnosticVFSGtkBookmarksPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_FILE,
	DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_BOOKMARKS
};
static void _g_slist_free_g_object_unref (GSList* self);
static void desktop_agnostic_vfs_gtk_bookmarks_set_file (DesktopAgnosticVFSGtkBookmarks* self, DesktopAgnosticVFSFile* value);
gboolean desktop_agnostic_vfs_file_exists (DesktopAgnosticVFSFile* self);
static void desktop_agnostic_vfs_gtk_bookmarks_parse (DesktopAgnosticVFSGtkBookmarks* self);
DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_monitor (DesktopAgnosticVFSFile* self);
static void desktop_agnostic_vfs_gtk_bookmarks_on_file_changed (DesktopAgnosticVFSGtkBookmarks* self, DesktopAgnosticVFSFileMonitor* monitor, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event);
static void _desktop_agnostic_vfs_gtk_bookmarks_on_file_changed_desktop_agnostic_vfs_file_monitor_changed (DesktopAgnosticVFSFileMonitor* _sender, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, gpointer self);
DesktopAgnosticVFSGtkBookmarks* desktop_agnostic_vfs_gtk_bookmarks_new (DesktopAgnosticVFSFile* file, gboolean monitor);
DesktopAgnosticVFSGtkBookmarks* desktop_agnostic_vfs_gtk_bookmarks_construct (GType object_type, DesktopAgnosticVFSFile* file, gboolean monitor);
gboolean desktop_agnostic_vfs_file_load_contents (DesktopAgnosticVFSFile* self, char** contents, gsize* length, GError** error);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_new_for_uri (const char* uri, GError** error);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_new_for_path (const char* path, GError** error);
GSList* desktop_agnostic_vfs_gtk_bookmarks_get_bookmarks (DesktopAgnosticVFSGtkBookmarks* self);
static void desktop_agnostic_vfs_gtk_bookmarks_finalize (GObject* obj);
static void desktop_agnostic_vfs_gtk_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_gtk_bookmarks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



DesktopAgnosticVFSBookmark* desktop_agnostic_vfs_bookmark_construct (GType object_type) {
	DesktopAgnosticVFSBookmark * self;
	self = (DesktopAgnosticVFSBookmark*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSBookmark* desktop_agnostic_vfs_bookmark_new (void) {
	return desktop_agnostic_vfs_bookmark_construct (DESKTOP_AGNOSTIC_VFS_TYPE_BOOKMARK);
}


DesktopAgnosticVFSFile* desktop_agnostic_vfs_bookmark_get_file (DesktopAgnosticVFSBookmark* self) {
	DesktopAgnosticVFSFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void desktop_agnostic_vfs_bookmark_set_file (DesktopAgnosticVFSBookmark* self, DesktopAgnosticVFSFile* value) {
	DesktopAgnosticVFSFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_file = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file), _tmp0_);
	g_object_notify ((GObject *) self, "file");
}


const char* desktop_agnostic_vfs_bookmark_get_alias (DesktopAgnosticVFSBookmark* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_alias;
	return result;
}


void desktop_agnostic_vfs_bookmark_set_alias (DesktopAgnosticVFSBookmark* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_alias = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_alias), _tmp0_);
	g_object_notify ((GObject *) self, "alias");
}


static void desktop_agnostic_vfs_bookmark_class_init (DesktopAgnosticVFSBookmarkClass * klass) {
	desktop_agnostic_vfs_bookmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSBookmarkPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_bookmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_bookmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_bookmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_BOOKMARK_FILE, g_param_spec_object ("file", "file", "file", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_BOOKMARK_ALIAS, g_param_spec_string ("alias", "alias", "alias", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void desktop_agnostic_vfs_bookmark_instance_init (DesktopAgnosticVFSBookmark * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_BOOKMARK_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_bookmark_finalize (GObject* obj) {
	DesktopAgnosticVFSBookmark * self;
	self = DESKTOP_AGNOSTIC_VFS_BOOKMARK (obj);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_alias);
	G_OBJECT_CLASS (desktop_agnostic_vfs_bookmark_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_bookmark_get_type (void) {
	static GType desktop_agnostic_vfs_bookmark_type_id = 0;
	if (desktop_agnostic_vfs_bookmark_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSBookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSBookmark), 0, (GInstanceInitFunc) desktop_agnostic_vfs_bookmark_instance_init, NULL };
		desktop_agnostic_vfs_bookmark_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSBookmark", &g_define_type_info, 0);
	}
	return desktop_agnostic_vfs_bookmark_type_id;
}


static void desktop_agnostic_vfs_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSBookmark * self;
	self = DESKTOP_AGNOSTIC_VFS_BOOKMARK (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_BOOKMARK_FILE:
		g_value_set_object (value, desktop_agnostic_vfs_bookmark_get_file (self));
		break;
		case DESKTOP_AGNOSTIC_VFS_BOOKMARK_ALIAS:
		g_value_set_string (value, desktop_agnostic_vfs_bookmark_get_alias (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSBookmark * self;
	self = DESKTOP_AGNOSTIC_VFS_BOOKMARK (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_BOOKMARK_FILE:
		desktop_agnostic_vfs_bookmark_set_file (self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_VFS_BOOKMARK_ALIAS:
		desktop_agnostic_vfs_bookmark_set_alias (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void _desktop_agnostic_vfs_gtk_bookmarks_on_file_changed_desktop_agnostic_vfs_file_monitor_changed (DesktopAgnosticVFSFileMonitor* _sender, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, gpointer self) {
	desktop_agnostic_vfs_gtk_bookmarks_on_file_changed (self, _sender, file, other, event);
}


DesktopAgnosticVFSGtkBookmarks* desktop_agnostic_vfs_gtk_bookmarks_construct (GType object_type, DesktopAgnosticVFSFile* file, gboolean monitor) {
	GParameter * __params;
	GParameter * __params_it;
	DesktopAgnosticVFSGtkBookmarks * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "file";
	g_value_init (&__params_it->value, DESKTOP_AGNOSTIC_VFS_TYPE_FILE);
	g_value_set_object (&__params_it->value, file);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	if (desktop_agnostic_vfs_file_exists (self->priv->_file)) {
		desktop_agnostic_vfs_gtk_bookmarks_parse (self);
	}
	if (monitor) {
		DesktopAgnosticVFSFileMonitor* _tmp0_;
		self->priv->_monitor = (_tmp0_ = desktop_agnostic_vfs_file_monitor (self->priv->_file), _g_object_unref0 (self->priv->_monitor), _tmp0_);
		g_signal_connect_object (self->priv->_monitor, "changed", (GCallback) _desktop_agnostic_vfs_gtk_bookmarks_on_file_changed_desktop_agnostic_vfs_file_monitor_changed, self, 0);
	}
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DesktopAgnosticVFSGtkBookmarks* desktop_agnostic_vfs_gtk_bookmarks_new (DesktopAgnosticVFSFile* file, gboolean monitor) {
	return desktop_agnostic_vfs_gtk_bookmarks_construct (DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS, file, monitor);
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void desktop_agnostic_vfs_gtk_bookmarks_parse (DesktopAgnosticVFSGtkBookmarks* self) {
	GError * _inner_error_;
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	self->priv->_bookmarks = (_tmp0_ = NULL, __g_slist_free_g_object_unref0 (self->priv->_bookmarks), _tmp0_);
	{
		char* contents;
		gsize length = 0UL;
		gint lines_size;
		gint lines_length1;
		char** lines;
		char* _tmp3_;
		gboolean _tmp2_;
		char* _tmp1_ = NULL;
		char** _tmp5_;
		char** _tmp4_;
		contents = NULL;
		lines = (lines_length1 = 0, NULL);
		_tmp2_ = desktop_agnostic_vfs_file_load_contents (self->priv->_file, &_tmp1_, &length, &_inner_error_);
		contents = (_tmp3_ = _tmp1_, _g_free0 (contents), _tmp3_);
		_tmp2_;
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		lines = (_tmp5_ = _tmp4_ = g_strsplit (contents, "\n", 0), lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL), lines_length1 = _vala_array_length (_tmp4_), lines_size = lines_length1, _tmp5_);
		{
			char** line_collection;
			int line_collection_length1;
			int line_it;
			line_collection = lines;
			line_collection_length1 = lines_length1;
			for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
				const char* line;
				line = line_collection[line_it];
				{
					gint tokens_size;
					gint tokens_length1;
					char** tokens;
					char** _tmp7_;
					char** _tmp6_;
					gboolean _tmp8_ = FALSE;
					tokens = (tokens_length1 = 0, NULL);
					if (_vala_strcmp0 (line, "") == 0) {
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						continue;
					}
					tokens = (_tmp7_ = _tmp6_ = g_strsplit (line, " ", 2), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), tokens_length1 = _vala_array_length (_tmp6_), tokens_size = tokens_length1, _tmp7_);
					if (tokens != NULL) {
						_tmp8_ = tokens[0] != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						DesktopAgnosticVFSBookmark* bookmark;
						char* _tmp9_;
						DesktopAgnosticVFSFile* _tmp10_;
						DesktopAgnosticVFSFile* _tmp11_;
						DesktopAgnosticVFSBookmark* _tmp13_;
						bookmark = desktop_agnostic_vfs_bookmark_new ();
						_tmp9_ = string_strip (tokens[0]);
						_g_free0 (_tmp9_);
						_tmp10_ = desktop_agnostic_vfs_file_new_for_uri (tokens[0], &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (bookmark);
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (contents);
							lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
							goto __catch0_g_error;
						}
						desktop_agnostic_vfs_bookmark_set_file (bookmark, _tmp11_ = _tmp10_);
						_g_object_unref0 (_tmp11_);
						if (tokens[1] == NULL) {
							desktop_agnostic_vfs_bookmark_set_alias (bookmark, NULL);
						} else {
							char* _tmp12_;
							_tmp12_ = string_strip (tokens[1]);
							_g_free0 (_tmp12_);
							desktop_agnostic_vfs_bookmark_set_alias (bookmark, tokens[1]);
						}
						self->priv->_bookmarks = g_slist_append (self->priv->_bookmarks, (_tmp13_ = bookmark, bookmark = NULL, _tmp13_));
						_g_object_unref0 (bookmark);
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		_g_free0 (contents);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			GSList* _tmp14_;
			g_critical ("vfs-bookmarks-gtk.vala:134: Could not load/parse GTK bookmarks file: %s", err->message);
			self->priv->_bookmarks = (_tmp14_ = NULL, __g_slist_free_g_object_unref0 (self->priv->_bookmarks), _tmp14_);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void desktop_agnostic_vfs_gtk_bookmarks_on_file_changed (DesktopAgnosticVFSGtkBookmarks* self, DesktopAgnosticVFSFileMonitor* monitor, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	switch (event) {
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED:
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED:
		{
			desktop_agnostic_vfs_gtk_bookmarks_parse (self);
			g_signal_emit_by_name (self, "changed");
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED:
		{
			GSList* _tmp0_;
			self->priv->_bookmarks = (_tmp0_ = NULL, __g_slist_free_g_object_unref0 (self->priv->_bookmarks), _tmp0_);
			g_signal_emit_by_name (self, "changed");
			break;
		}
		default:
		{
			break;
		}
	}
}


static void desktop_agnostic_vfs_gtk_bookmarks_set_file (DesktopAgnosticVFSGtkBookmarks* self, DesktopAgnosticVFSFile* value) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (value == NULL) {
		char* fname;
		char* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		DesktopAgnosticVFSFile* _tmp2_;
		fname = NULL;
		fname = (_tmp0_ = g_build_filename (g_get_home_dir (), ".gtk-bookmarks", NULL), _g_free0 (fname), _tmp0_);
		_tmp1_ = desktop_agnostic_vfs_file_new_for_path (fname, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (fname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->_file = (_tmp2_ = _tmp1_, _g_object_unref0 (self->priv->_file), _tmp2_);
		_g_free0 (fname);
	} else {
		DesktopAgnosticVFSFile* _tmp3_;
		self->priv->_file = (_tmp3_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file), _tmp3_);
	}
	g_object_notify ((GObject *) self, "file");
}


GSList* desktop_agnostic_vfs_gtk_bookmarks_get_bookmarks (DesktopAgnosticVFSGtkBookmarks* self) {
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_bookmarks;
	return result;
}


static void desktop_agnostic_vfs_gtk_bookmarks_class_init (DesktopAgnosticVFSGtkBookmarksClass * klass) {
	desktop_agnostic_vfs_gtk_bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSGtkBookmarksPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_gtk_bookmarks_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_gtk_bookmarks_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_gtk_bookmarks_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_FILE, g_param_spec_object ("file", "file", "file", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_BOOKMARKS, g_param_spec_pointer ("bookmarks", "bookmarks", "bookmarks", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", DESKTOP_AGNOSTIC_VFS_TYPE_GTK_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void desktop_agnostic_vfs_gtk_bookmarks_instance_init (DesktopAgnosticVFSGtkBookmarks * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_gtk_bookmarks_finalize (GObject* obj) {
	DesktopAgnosticVFSGtkBookmarks * self;
	self = DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS (obj);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->_monitor);
	__g_slist_free_g_object_unref0 (self->priv->_bookmarks);
	G_OBJECT_CLASS (desktop_agnostic_vfs_gtk_bookmarks_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_gtk_bookmarks_get_type (void) {
	static GType desktop_agnostic_vfs_gtk_bookmarks_type_id = 0;
	if (desktop_agnostic_vfs_gtk_bookmarks_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSGtkBookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_gtk_bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSGtkBookmarks), 0, (GInstanceInitFunc) desktop_agnostic_vfs_gtk_bookmarks_instance_init, NULL };
		desktop_agnostic_vfs_gtk_bookmarks_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSGtkBookmarks", &g_define_type_info, 0);
	}
	return desktop_agnostic_vfs_gtk_bookmarks_type_id;
}


static void desktop_agnostic_vfs_gtk_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSGtkBookmarks * self;
	self = DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_BOOKMARKS:
		g_value_set_pointer (value, desktop_agnostic_vfs_gtk_bookmarks_get_bookmarks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_gtk_bookmarks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSGtkBookmarks * self;
	self = DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_GTK_BOOKMARKS_FILE:
		desktop_agnostic_vfs_gtk_bookmarks_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




