#include "compat.h"

#ifndef HAS_GETOPT

extern "C" {

#include <string.h>
#include <stdio.h>

int optind = 0;
static int optind2 = 1;

// simplified getopt
// does only what tthsum needs (only argumentless options)
int getopt(int argc, char* const argv[], char const* optstring) {
	if(!optind) {
		int start = 1;
		while(true) {
			int first_non_opt = 0;
			for(int i = start; i < argc; ++i) {
				if(argv[i][0] == '-' && argv[i][1] == '-' && argv[i][2] == '\0') {
					optind++;
					i = argc;
					break;
				} else if(argv[i][0] != '-' || (argv[i][0] == '-' && argv[i][1] == '\0')) {
					if(!first_non_opt)
						first_non_opt = i;
				} else {
					for(size_t j = 1; j < strlen(argv[i]); ++j) {
						if(strchr(optstring, argv[i][j]) == NULL) {
							fprintf(stderr, "%s: invalid option -- %c\n", argv[0], argv[i][j]);
							return '?';
						}
					}
					if(first_non_opt) {
						for(int k = i; k > first_non_opt; --k) {
							char const* tmp = argv[k];
							*((char const**)argv + k) = argv[k - 1];
							*((char const**)argv + k - 1) = tmp;
						}
						start = first_non_opt + 1;
						break;
					}
				}
			}
			if(argc == i)
				break;
		}
		optind++;
	}

	while(true) {
		if(optind >= argc)
			return -1;
		if(argv[optind][0] != '-' || (argv[optind][0] == '-' && argv[optind][1] == '\0'))
			return -1;
		if(argv[optind][0] == '-' && argv[optind][1] == '-' && argv[optind][2] == '\0') {
			optind++;
			return -1;
		}
	    if(argv[optind][optind2] != '\0')
			return argv[optind][optind2++];
		optind++;
		optind2 = 1;
	}
	return -1;
}

} // extern "C"

#endif
