use Test::More tests => 261;

use Data::Float 0.000 qw(significand_bits);
use IO::File 1.03;

BEGIN {
	use_ok Data::Entropy::Source;
	use_ok Data::Entropy, qw(with_entropy_source);
	use_ok Data::Entropy::Algorithms, qw(rand);
}

$skip_all = significand_bits < 47;

with_entropy_source +Data::Entropy::Source->new(
		IO::File->new("t/test0.entropy", "r") || die($!), "getc"
), sub {
	while(<DATA>) {
		chop;
		SKIP: {
			skip "non-standard fraction length", 1 if $skip_all;
			is sprintf("%.5f", rand(7)), $_;
		}
	}
	SKIP: {
		skip "non-standard fraction length", 2 if $skip_all;
		is sprintf("%.5f", rand), "0.40339";
		is sprintf("%.5f", rand(0)), "0.57643";
	}
}

__DATA__
4.03949
6.26147
2.24646
3.31700
2.63184
1.41796
1.75632
6.38682
6.21075
1.63176
5.71063
2.43165
3.18495
2.78352
4.11310
5.58357
1.76606
3.94127
5.90934
2.27813
1.95405
4.46778
4.57601
4.51026
4.30349
2.60453
2.00978
4.45786
6.37942
2.27727
1.88362
4.15862
0.57427
0.96454
2.60107
1.90690
1.13613
6.70783
2.43433
2.24860
1.40735
2.10218
5.67393
3.51704
0.24440
4.29856
6.91233
0.94936
6.75088
0.74813
2.42188
6.62988
5.21451
6.90324
3.60941
6.35343
4.18760
0.89604
2.08841
0.09973
2.00711
5.69009
2.07490
3.89745
0.69842
2.87520
6.72101
6.07440
1.23840
2.18090
5.15799
2.54962
0.55972
0.43877
0.67409
2.20667
4.32117
3.43950
0.62849
1.86054
1.04994
5.74697
0.87189
4.37112
3.38660
6.99221
2.99821
2.81080
0.86609
1.49858
1.29385
1.76830
4.43088
6.44048
3.71470
5.08121
4.64473
5.31372
0.34369
1.06673
2.74852
4.54882
6.37792
1.08316
3.15476
3.63793
2.75349
5.54332
2.80939
1.78511
4.93116
2.43973
2.26185
5.38060
3.52985
3.94641
5.33728
4.26592
5.74231
3.46603
6.37356
3.00379
4.77121
3.88470
0.40732
2.54157
6.38269
1.85012
0.76890
2.97151
6.22267
2.06356
1.33057
5.44889
2.30828
0.26282
4.69865
3.74545
2.13907
3.46982
6.17097
5.63820
1.32550
1.61326
0.33302
5.13187
6.72437
3.29962
2.37014
3.47556
0.56813
5.25896
2.13548
6.66921
4.50784
5.42553
2.68242
5.70127
3.55900
0.05206
3.96886
2.68604
1.53927
4.48165
5.82785
1.11145
6.54273
2.13742
2.54401
6.59339
6.63027
5.43635
5.12821
6.87728
5.24629
1.29661
2.37573
6.98835
0.19256
2.07780
2.43141
0.94029
0.69126
3.09621
0.52342
3.11194
1.06508
6.85913
0.21614
6.99600
5.67229
0.78744
0.84214
6.67875
5.50226
0.59036
4.40295
6.45787
0.90274
3.74152
3.92806
5.63668
6.50168
2.97061
1.47128
3.39240
5.76571
4.51666
6.43616
0.93874
2.53152
1.55657
5.85942
2.73972
3.46216
2.21395
4.92681
2.64671
3.00646
4.74593
1.42706
6.38814
0.15958
3.31778
0.40831
1.32963
4.11706
0.15047
1.26295
0.11315
1.95935
3.44559
3.87174
0.48446
0.81557
4.61928
1.54109
0.05700
1.87977
0.32297
3.99102
6.07300
2.80843
6.40068
6.80164
0.07676
3.85847
1.10786
2.09193
1.57233
4.67734
4.16937
1.02375
5.07615
0.88993
1.92688
