/* 
 * $Id: ctksignal.h,v 1.15 2000/07/24 19:28:58 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKSIGNAL_H__
#define __CTKSIGNAL_H__

typedef struct ctksignal_s 
{
      gint   id;
      gchar* name;
} CtkSignal_s;

typedef gint CdkInputSource;

typedef enum
{
  CDK_NOTHING		= -1,
  CDK_DELETE		= 0,
  CDK_DESTROY		= 1,
  CDK_BUTTON_PRESS	= 4,
  CDK_BUTTON_RELEASE	= 7,
  CDK_KEY_PRESS		= 8,
  CDK_KEY_RELEASE	= 9,
  CDK_ENTER_NOTIFY	= 10,
  CDK_LEAVE_NOTIFY	= 11,
  CDK_FOCUS_CHANGE	= 12
} CdkEventType;

typedef struct CdkEventAny_S
{
      CdkEventType type;
      // GdkWindow* window;
      // gint8 send_event;
} CdkEventAny;

typedef struct CdkEventKey_S
{
      CdkEventType type;
      gint   keyval;
      gint   length;
      gchar* string;
} CdkEventKey;

typedef struct CdkEventButton_S
{
      CdkEventType type;
      gint x;
      gint y;
      gint dx;
      gint dy;
} CdkEventButton;

typedef struct CdkEventFocus_S
{
      CdkEventType type;
} CdkEventFocus;

typedef struct CdkEventCrossing
{
      CdkEventType type;
      gint x;
      gint y;
} CdkEventCrossing;

typedef union CdkEvent_U
{
      CdkEventType     type;
      CdkEventAny      any;
      CdkEventButton   button;
      CdkEventFocus    focus_change;
      CdkEventCrossing crossing;
} CdkEvent;

typedef gboolean (*CtkSignalFunc)();
#define CTK_SIGNAL_FUNC(f)  ((CtkSignalFunc) f)

typedef struct CtkSignal_S 
{
      CtkObject*    object;
      gchar*        event;
      CtkSignalFunc sig_func; // If NULL, then this signal has been removed.
      gpointer      data;
      gpointer      object_data;
      guint         signal_id;
      gint          connection_id;
} CtkSignal;

guint    ctk_signal_new(const gchar *event, CtkType object_type);
void     ctk_signal_disconnect(CtkObject* object, gint id);
gint     ctk_signal_connect(CtkObject *object, gchar *event, CtkSignalFunc func, gpointer data);
gint     ctk_signal_connect_after(CtkObject *object, gchar *event, CtkSignalFunc func, gpointer data);
gint     ctk_signal_connect_object(CtkObject *object, gchar *event, CtkSignalFunc func, CtkObject *slot_object);
gboolean ctk_event_emit_by_name (CtkObject* object, gchar* event);
void     ctk_signal_emit_by_name(CtkObject *object, gchar *event);
void     ctk_signal_destroy_all_signals(CtkWidget *widget);

extern gboolean ctk_signal_return;
extern gboolean ctk_signal_run;

#endif
