/* 
 * $Id: ctkmenu.h,v 1.8 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTK_MENU_H__
# define __CTK_MENU_H__ 

typedef struct CtkMenu_S 
{
      CtkMenuShell menushell;
      CtkWidget*   window;
      CtkWidget*   scrolledwindow;

      gint selected_item;
      gint num_items;
} CtkMenu;

void ctk_menu_init(CtkMenu *menu);
CtkWidget *ctk_menu_new(void);
void ctk_menu_append(CtkMenu *menu, CtkWidget *child);
void ctk_menu_prepend(CtkMenu *menu, CtkWidget *child);
void ctk_menu_insert(CtkMenu *menu, CtkWidget *child, gint position);
CtkWidget *ctk_menu_get_active(CtkMenu *menu);
void ctk_menu_set_active(CtkMenu *menu, gint index);
CtkMenuItem *ctk_menu_get_selected_item(CtkMenu *menu);
gint ctk_menu_get_selected_index(CtkMenu *menu);

#define CTK_MENU(obj)	CTK_CHECK_CAST((obj),CtkMenu,CtkTypeMenu)

#endif
