/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.set.AbstractSetDecorator;

public final class UnmodifiableEntrySet
extends AbstractSetDecorator
implements Unmodifiable {
    public static final Set decorate(Set set) {
        if (set instanceof Unmodifiable) {
            return set;
        }
        return new UnmodifiableEntrySet(set);
    }

    public final boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public final boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public final boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public final boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public final Iterator iterator() {
        return new UnmodifiableEntrySetIterator(this.collection.iterator());
    }

    public final Object[] toArray() {
        Object[] array = this.collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = new UnmodifiableEntry((Map.Entry)array[i]);
            ++i;
        }
        return array;
    }

    public final Object[] toArray(Object[] array) {
        Object[] result = array;
        if (array.length > 0) {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
        }
        result = this.collection.toArray(result);
        int i = 0;
        while (i < result.length) {
            result[i] = new UnmodifiableEntry((Map.Entry)result[i]);
            ++i;
        }
        if (result.length > array.length) {
            return result;
        }
        System.arraycopy(result, 0, array, 0, result.length);
        if (array.length > result.length) {
            array[result.length] = null;
        }
        return array;
    }

    private UnmodifiableEntrySet(Set set) {
        super(set);
    }

    static final class UnmodifiableEntrySetIterator
    extends AbstractIteratorDecorator {
        public final Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new UnmodifiableEntry(entry);
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected UnmodifiableEntrySetIterator(Iterator iterator) {
            super(iterator);
        }
    }

    static final class UnmodifiableEntry
    extends AbstractMapEntryDecorator {
        public final Object setValue(Object obj) {
            throw new UnsupportedOperationException();
        }

        protected UnmodifiableEntry(Map.Entry entry) {
            super(entry);
        }
    }
}

