/***************************************************************************
 $RCSfile: tutorial3.cpp,v $
                             -------------------
    cvs         : $Id: tutorial3.cpp,v 1.1 2003/04/24 01:43:47 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * This is a small tutorial on how to use the basic functions of the
 * libchipcard. It just determines whether an inserted card is a processor
 * or a memory card.
 *
 * This version now does error checking.
 *
 * Usage:
 *   tutorial3
 */


#include <stdio.h>

// you need only the following include
#include "chipcard.h"





int main(int argc,char **argv) {
  CTError err;
  CTCardTrader *trader;
  CTCard *card;

  trader=new CTCardTrader(false,
			  0,
			  0,
			  CHIPCARD_STATUS_INSERTED,
			  CHIPCARD_STATUS_INSERTED |
			  CHIPCARD_STATUS_LOCKED_BY_OTHER,
			  0);
  err=trader->start();
  if (!err.isOk()) {
    fprintf(stderr, "Error starting the trader: %s\n",
	    err.errorString().c_str());
    return 3;
  }

  fprintf(stderr,"Please insert your card.\n");
  err=trader->getNext(card, 30);
  if (!err.isOk()) {
    fprintf(stderr, "Have no card: %s\n",
	    err.errorString().c_str());
    return 3;
  }

  fprintf(stderr,"Card inserted, working.\n");

  err=card->openCard();
  if (!err.isOk()) {
    printf("ERROR: Opening card. (%s)\n",
	   err.errorString().c_str());
    return 1;
  }

  // check if it is a processor or memory card
  if (card->isProcessorCard())
    printf("The card is a processor card.\n");
  else {
    printf("The card is a memory card (size=%d).\n",
	   card->memorySize());
  }

  err=card->closeCard();

  /* we allow the error code 0x62 to be valid, since this code shows
   * that the card is disconnected, which was the intention of closing
   * the card. Hence the parameter 0x62 */
  if (!err.isOk(0x62)) {
    printf("ERROR: Closing card. (%s)\n",
	   err.errorString().c_str());
    return 1;
  }

  err=trader->stop();
  if (!err.isOk()) {
    fprintf(stderr, "Error stopping the trader: %s\n",
	    err.errorString().c_str());
    return 3;
  }


  printf("Bye.\n");
  return 0;
}







