/***************************************************************************
 $RCSfile: ctmemorycard.cpp,v $
                             -------------------
    cvs         : $Id: ctmemorycard.cpp,v 1.6 2003/04/24 01:43:29 aquamaniac Exp $
    begin       : Wed Aug 29 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif

#include "ctmemorycard.h"

#include "cterror.h"
#include "ctpointer.h"
#include "ctcommand.h"
#include "ctcard.h"
#include "ctmisc.h"
#include <engine/chameleon/error.h>
#include <engine/chameleon/debug.h>


CTMemoryCard::CTMemoryCard(const CTCard &c):CTCard(c) {
}


CTMemoryCard::~CTMemoryCard(){
}


CTError CTMemoryCard::verifyPin(const string &pin){
    CTCommand cmd;

    cmd.setCla(0x00);      // chip card command
    cmd.setIns(0x20);      // VERIFY
    cmd.setP1(0);
    cmd.setP2(0);
    cmd.setData(pin);
    cmd.setLr(0);
    return execCommand(cmd);
}


CTError CTMemoryCard::changePin(const string &oldpin, const string &newpin){
    CTCommand cmd;

    cmd.setCla(0x00);      // chip card command
    cmd.setIns(0x24);      // CHANGE_PIN
    cmd.setP1(0);
    cmd.setP2(0);
    cmd.setData(oldpin);
    cmd.addData(newpin);
    cmd.setLr(0);
    return execCommand(cmd);
}


CTError CTMemoryCard::selectFile(unsigned short fid){
  string response;

  return execCommand("select_file_w",
		   _cmdSelectFile,
		   response,
		   CTMisc::num2string(fid));
}


CTError CTMemoryCard::reopenCard(){
  DBG_INFO("LIBCHIPCARD: The method \"CTMemoryCard::reopenCard()\"\n"
	   "has been called. Since THIS class does nothing on this method\n"
	   "I guess you have an error in your program.");
  return CTError();
}


string CTMemoryCard::cardType(){
  return "CTMemoryCard";
}


string CTMemoryCard::cardTypes(){
  return CTCard::cardTypes()+",CTMemoryCard";
}


CTError CTMemoryCard::selectMF(string &fcp){
  return execCommand("select_mf",
		     _cmdSelectMF,
		     fcp);
}



