/***************************************************************************
 $RCSfile: ctreadercontext.h,v $
                             -------------------
    cvs         : $Id: ctreadercontext.h,v 1.1 2003/04/24 01:43:28 aquamaniac Exp $
    begin       : Wed Apr 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CTREADERCONTEXT_H
#define CTREADERCONTEXT_H


#include <chipcard/cterror.h>
#include <chipcard/libchipcard.h>


/**
 * This is the class which really interfaces to the C-part of libchipcard.
 */
class CHIPCARD_API CTReaderContext {
private:
  unsigned int _readerId;
  unsigned int _cardId;
  int _readerNumber;
  CHIPCARD_READERDESCR _readerDescr;
  bool _connected;
  unsigned int _flags;
  unsigned int _status;

public:
  CTReaderContext(unsigned int tid,
		  unsigned int cardId=0,
		  unsigned int flags=0,
		  unsigned int status=0);
  CTReaderContext();
  virtual ~CTReaderContext();

  unsigned int readerFlags() const { return _flags;};
  unsigned int readerStatus() const { return _status;};
  unsigned int readerId() const { return _readerId;};
  unsigned int cardId() const { return _cardId;};
  int readerNumber() const { return _readerNumber;};
  void setReaderNumber(int i) { _readerNumber=i;};
  bool connected() const { return _connected;};
  void setConnected(bool b) { _connected=b;};
  const CHIPCARD_READERDESCR &readerDescription() const {
    return _readerDescr;
  };
  void setReaderDescription(const CHIPCARD_READERDESCR &rd) {
    _readerDescr=rd;
  };

};





#endif





