/*
 *  client/main.c  --  LysKOM client, main program
 *
 *
 *  Copyright (C) 1990  Lysator Computer Club
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  E-mail:	Bellman@Lysator.LiU.SE
 */


#include <config.h>
#include <stdio.h>
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef __vax__
#define __SIZE_T included from stdlib.h
#define __WCHAR_T included from stdlib.h
#endif

#include <libintl.h>

#include <kom-types.h>
#include <zmalloc.h>
#include <s-string.h>

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#include <services.h>

/* Must be included before "read-line.h" on a vax because it includes <sgtty.h>
 * and that does not work after inclusion of <sys/ioctl.h> because of
 * stupid include-file construction.
 */
#include "xoutput.h"

#include "error.h"
#include "read-line.h"
#include "commands.h"
#include "cmds.h"
#include "internal.h"
#include "cache.h"
#include "edit.h"
#include "offline.h"
#include "main.h"

#include "defaults.h"

char		* server_name;
int		  portno;
Info		  serv_info;
char		* client_name;
int		  offline = 0;
#ifdef TRACE
unsigned long	  trace = 0;
#endif

int
main (int	   argc,
      char	** argv)

{
#define FUNCTION "main()"

    s_set_storage_management (zmalloc, zrealloc, zfree);
    kom_set_storage_management (zmalloc, zrealloc, zfree);
#ifdef HAVE_LOCALE_H
    setlocale(LC_ALL, "");
#endif
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);

    init_cmd_list();	/* Initialize the list of commands */
    init_terminal (stdin, stdout);
    init_cache();

    client_name = argv[0];
    if (!client_name)
	client_name = "(unknown)";

    server_name = DEFAULT_SERVER;
    portno = DEFAULT_PORTNO;

    /* Aronsson was here: 7 bit character size conversion for terminals */
    /* For now, argument parsing is very primitive. */
    /* Perhaps we should consider GNU's getopt. */
    while (argc > 1)
    {
        if (0 == strcmp(argv[1], "--iso"))
	    charset=0;
	else if (0 == strcmp(argv[1], "--pc8"))
	    charset=1;
	else if (0 == strcmp(argv[1], "--sw7"))
	    charset=2;
	else if (0 == strcmp(argv[1], "--mac"))
	    charset=3;
	else if (0 == strcmp(argv[1], "--tomradavslutar"))
	    tomrad_avslutar = 1;
	else if (0 == strcmp(argv[1], "--offline"))
	    offline = 1;
#ifdef TRACE
	else if (0 == strncmp(argv[1], "--trace=", 8))
	{
	    int bitpos;

	    trace = strtoul(argv[1] + 8, NULL, 0);
	    xprintf("Tracemap set to %lu=0%lo=0x%lx:\n", trace, trace, trace);
	    for (bitpos = 0; bitpos < 8; bitpos++)
	    {
		if (TRACE(bitpos))
		    xprintf("Region %d enabled.\n", bitpos);
		else
		    xprintf("Region %d disabled.\n", bitpos);
	    }
	    xprintf("Regions meanings:\n");
	    xprintf("0 - low volume upload/download trace\n");
	    xprintf("1 - storing on disk (for offline reading)\n");
	    xprintf("2 - fetching from disk (for offline reading)\n");
	    xprintf("3 - internal cache things\n");
	    xprintf("4 - upload\n");
	    xprintf("5 - download\n");
	    xprintf("6 - internal trace of reading\n");
	    /* xprintf("7 - not used\n"); */
	    xprintf("\n");
	}
#endif
	else if (argv[1][0] != '-')
	{
	    char * p;

	    /* Don't use strdup here. It does not exist on ULTRIX */
	    server_name = (char *) zmalloc(strlen(argv[1]) + 1);
	    strcpy(server_name, argv[1]);

	    if ((p = strchr(server_name, ':')) != NULL)
	    {
		portno = atoi(p + 1);
		*p = '\0';
	    }
	} else {
	    xprintf ("Usage: [--iso] [--pc8] [--mac] [--sw7] [--tomradavslutar] [--offline] [server]\n");
	    restore_terminal (stdin, stdout);
	    exit(1);
	}
	
	argc --;
	argv ++;
    }
    /* Here argv and argc are irreparably destroyed. */

    if (!offline)
    {
	if (kom_open_connection(server_name, portno) == FAILURE)
	{
	    xprintf (gettext("Jag kan inte komma i kontakt med %s. Frsk igen.\n"), server_name);
	    restore_terminal (stdin, stdout);
	    exit(1);
	}

	/*  OK, connection established  */
	/* BUG: Retval not checked */
	kom_get_info (&serv_info);

	/*  Greet user  */
	xprintf (gettext("Vlkommen till LysKOM server %s, version %d.\n"
			 "Du kr TTY-klienten, version %s.\n"),
		 server_name,
		 serv_info.version,
		 VERSION);
	xprintf ("\n");
	if (serv_info.motd_of_lyskom)
	    show_text_no (serv_info.motd_of_lyskom);

	/*  Log in to server  */
	cmd_start_anew (EMPTY_STRING);
    }
    else
    {
        /* Verify that we can open and read the cache. */
        Pers_no pno;

        if (fetch_person_number(&pno) == FAILURE)
	{
	    xprintf(gettext("Kan inte kra offline. Databasen saknas.\n"));
	    restore_terminal (stdin, stdout);
	    exit(1);
	}

	cache_change_person(pno);
    }

    /*  And run the command loop  */
    command_loop ();

    /* Restore the terminal to the old settings */
    restore_terminal (stdin, stdout);

    return 0;	/*  LysKOM can *never* be wrong! */
#undef FUNCTION
}

