/*
 * Copyright 1994 Linus Tolke, Lysator.
 */

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
#include <stdio.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#if STDC_HEADERS
#include <stdlib.h>
#endif
#include <stdarg.h>
#include <sysexits.h>

#if STDC_HEADERS || HAVE_STRING_H
#  include <string.h>
#  if !STDC_HEADERS && HAVE_MEMORY_H
#    include <memory.h>
#  endif
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#  include <strings.h>
   /* memory.h and strings.h conflict on some systems.  */
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#ifdef __vax__
#define __SIZE_T included from stdlib.h
#define __WCHAR_T included from stdlib.h
#endif
#include <kom-types.h>
#define LYSKOM_NAME_LEN 200
#include <s-string.h>
#include <services.h>

#include <kom-errno.h>

#include "mail.h"
#include "db.h"
#include "params.h"


/* Hj{lpfunktioner */
void
log_message(const char * format,
	    ...)
{
    va_list	args;

    va_start(args, format);
    vfprintf(stderr,format,args);
    va_end(arg);
}
void
failure(int exit_status)
{
    exit(exit_status);
}

/* VARARGS */void
skicka_brev(const char	* mott1,
	    const char	* mott2,
	    const char	* subject,
	    const char	* formatstring,
	    ...)
{
    char   argline[1000];	/* Hoppas det r{cker. */
    FILE * out;
    va_list	args;

    sprintf(argline,MAILER " %s %s", 
	    (mott1 ? mott1 : ""),
	    (mott2 ? mott2 : ""));
    out = popen(argline,"w");
    /* Construct the header. */
    fprintf(out, "Subject: %s\nFrom: Lyskoms brevdemon <" POSTMASTER ">\n",
	    subject);
    va_start(args, formatstring);
    vfprintf(out,formatstring,args);
    va_end(args);
    fclose(out);
}
	    

/* Huvudprogram. Sk|ter uppkopplingen mot kom-databasen. mm */

static Pers_no
get_unique_recipient(const char *str)
{
    Pers_no res;
#if HAVE_STRTOULE
    char *end;

    res = strtoul(str, &end, 10);

    if (*end != '\0')
	res = 0;
#else
    res = atol(str);
#endif

    if (res == 0) 
	sscanf(str, "Person %hu", &res);

    if (res == 0) 
	sscanf(str, "\"Person %hu\"", &res);

    if (res == 0) 
	sscanf(str, "P%hu", &res);

    if (res == 0) 
	sscanf(str, "p%hu", &res);

    return res;
}



int
main(int	   argc,
      char 	** argv) 
{
    char *	text;
    int		mott;

    /* L{s in hela brevet. Detta kan g|ra exit(EX_DATAERR) */
    text = read_mail();

    /* Nu har vi en mottagare vi skall sl} upp. */
    /* Kolla f|rst det gamla s{ttet att ange mottagare... */
    
    if (argc != 2) {
	exit(EX_DATAERR);
    }
    mott = get_unique_recipient(argv[1]);


    /* Logga in i kom */
    s_set_storage_management(malloc, realloc, free);
    kom_set_storage_management(malloc, realloc, free);

    if ( kom_open_connection(KOMSERVER, KOMPORT) != OK )
    {
	log_message("can't reach server '%s' on port %d", KOMSERVER, KOMPORT);
	exit(EX_TEMPFAIL);
    }

    if ( kom_login(LYSKOMPOSTMASTER,
		   s_fcrea_str((const unsigned char *)PASSWORD),
		   TRUE)!= OK )
    {
	switch(kom_errno)
	{
	case KOM_LOGIN_DISALLOWED:
	    log_message("login not allowed.");
	    /* This is a serious error. Misconfigured system. */
	    exit(EX_TEMPFAIL);
	    
	case KOM_UNDEF_PERS:
	    log_message("person %d doesn't exist.", LYSKOMPOSTMASTER);
	    skicka_brev(POSTMASTER, 0,
			"problem med mailtokom",
			"kan inte logga in i lyskom, finns inte");
	    exit(EX_UNAVAILABLE);

	case KOM_PWD:
	    log_message("wrong password.");
	    skicka_brev(POSTMASTER, 0,
			"problem med mailtokom",
			"kan inte logga in i lyskom, fel 'l|sen'");
	    exit(EX_UNAVAILABLE);

	default:
	    log_message("unexpected kom-error %d", kom_errno);
	    skicka_brev(POSTMASTER, 0,
			"problem med mailtokom",
			"kan inte logga in i lyskom, konstig fel: %d",
			kom_errno);
	    exit(EX_UNAVAILABLE);
	}
    }


    if (mott == 0) {
	/* Ajd}, det gick inte med det gamla s{ttet.
	   Nu m}ste vi sl} upp namnet. 
	   Det var ju en himla tur att vi redan var inloggade... 
	 */
	char *	mottnamn = (char *) malloc(strlen(argv[1]) + 1);
	char * 	p;

	strcpy(mottnamn, argv[1]);

	/* byta '.' mot space */
	for (p = mottnamn; (p = strchr(p, '.')); *p = ' ');

	/* S}, nu skall vi f|rs|ka snoka reda p} vem mottagaren {r. */
	{
	    Conf_z_info_list	list_of_matches = EMPTY_CONF_Z_INFO_LIST;
	    unsigned short	i;
	    Success		retval;

	    /* Detta kan vara b}de person och m|te, inga konstigheter. */
	    retval = kom_lookup_z_name(s_fcrea_str(mottnamn), 
				       TRUE, /* Persons */
				       TRUE, /* Conferences */
				       &list_of_matches);
	    if (retval == FAILURE) {
		log_message("Cannot lookup name %d\n", kom_errno);
		exit(EX_UNAVAILABLE);
	    }

	    /* Nu har vi lyckats sl} upp namnet. [r det noll eller tv} eller 
	       fler s} {r det "fel" 
	     */

	    if (list_of_matches.no_of_confs == 0) {
		/* 
		skicka_brev(POSTMASTER, vilket_errorsto(),
			    "Kunde inte leverera brevet",
			    "Ditt brev till %s kunde inte levereras.\n"
			    "Anledning: det finns ingen s}dan anv{ndare i "
			    "Lyskom.",
			    argv[1]);
		 */
		failure(EX_NOUSER);
		/*NOTREACHED*/
	    } else if (list_of_matches.no_of_confs > 1) {
		/* Aha, 2 eller fler mottagare. D} {r det fel.
		   Bygg en snyck feltext.
		 */
		char * allamott =
		    (char *) malloc(LYSKOM_NAME_LEN 
				    * list_of_matches.no_of_confs);

		strcpy(allamott,"");

		for (i = 0; i < list_of_matches.no_of_confs; i++) {
		    strcat(allamott, "	");
		    strcat(allamott, 
			   s_crea_c_str(list_of_matches.confs[i].name));
		    strcat(allamott, "\n");
		}
		skicka_brev(POSTMASTER, vilket_errorsto(),
			    "Vill inte leverera brevet",
			    "Ditt brev till %s kunde inte levereras.\n"
			    "Anledning: du kan mena n}gon av f|ljande "
			    "personer:\n"
			    "%s\n\n"
			    "H{r {r ditt inl{gg s} som det hade sett ut i "
			    "LysKOM:\n"
			    "[rende: %s\n",
			    argv[1],
			    allamott,
			    text
			    );
		/* Om vi skickar ett eget svarsbrev s} "gick det ju bra" */
		failure(EX_OK);
		/*NOTREACHED*/
	    } else {
		/* Vi lyckades f} precis en tr{ff. Bra. */
		mott = list_of_matches.confs[0].conf_no;
		/* Allt gick bra. */
	    }
	}
    }
    /* Nu har vi mottagaren i mott. */

    /* Kolla om texten redan finns... */

    /* Skapa texten. */
    {
	Misc_info	info[1];
	Text_no		created_text;

	info[0].type = recpt;
	info[0].datum.recipient = mott;

	/* Kolla om detta {r en kommentar till en redan befintlig text */

	created_text = kom_create_text(s_fcrea_str(text),
				       1, info);

	if (created_text == 0) {
	    switch(kom_errno) {
	    case KOM_CONF_ZERO:
		/* Om vi lyckas f} KOM_CONF_ZERO s} {r det n}got skumt
		   i detta programmet.
		 */
	    case KOM_UNDEF_CONF:
	    case KOM_UNDEF_PERS:
		/* Det finns ingen s}dan anv{ndare... */
		/*
		skicka_brev(POSTMASTER,vilket_errorsto(),
			    "Det finns ingen s}dan lyskomare",
			    "Brevet till %s gick inte att leverera.\n"
			    "Det finns ingen s}dan lyskomare: "
			    "Person/m|te %d.\n"
			    "Lyskom gav felet %d.",
			    argv[1], mott, kom_errno);
		 */
		failure(EX_NOUSER);
		/*NOTREACHED*/
	    case KOM_LONG_STR:
		/* Texten {r f|r l}ng. */
		skicka_brev(POSTMASTER,vilket_errorsto(),
			    "Ditt brev {r f|r l}ngt",
			    "Brevet till %s gick inte att leverera.\n"
			    "Det var f|r l}ngt.\n\n"
			    "Lyskom gav felet %d.",
			    argv[1], kom_errno);
		failure(EX_DATAERR);
		/*NOTREACHED*/
		    
	    case KOM_ACCESS:
	    case KOM_PERM:
		/* Vi f}r inte skriva i det m|tet. */
		skicka_brev(POSTMASTER,vilket_errorsto(),
			    "Du f}r inte skicka brev dit.",
			    "Brevet till %s gick inte att leverera.\n"
			    "Det m|tet eller den brevl}dan har du inte "
			    "till}telse att skicka brev till.\n"
			    "Lyskom gav felet %d.",
			    argv[1], kom_errno);
		failure(EX_NOPERM);
		/*NOTREACHED*/
	    case KOM_TEMPFAIL:
		failure(EX_TEMPFAIL);
		/*NOTREACHED*/
	    default:
		/* N}got annat fel. Det skall nog inte h{nda. */
		skicka_brev(POSTMASTER,vilket_errorsto(),
			    "Det gick inte att l{gga in ditt brev",
			    "Brevet till %s gick inte att leverera.\n"
			    "Lyskom gav felet %d.\n\n"
			    "Det finns ingen t{nkbar f|rklaring till detta "
			    "felet. Antagligen {r det\n"
			    "fel i programmet som skall f|rs|ka l{gga in "
			    "det eller ocks} {r lyskom-\n"
			    "systemet skakigt.",
			    argv[1], kom_errno);
		failure(EX_SOFTWARE);
		/*NOTREACHED*/
	    }
	}
	/* Nu har vi lagt in texten och det gick bra. */


	/* Registrera i databasen. */
	db_stuff(vilket_messageid(),created_text);
    }
    exit(EX_OK);
}
