from qt import *
from kdeemul import *

class LPrefsDialog(KDialogBase):
	def __init__(self):
		KDialogBase.__init__(self, KDialogBase.Tabbed, i18n("Preferences"), KDialogBase.Ok+KDialogBase.Cancel,	KDialogBase.Ok,None, "preferences", True)
		self.addGeneralItems()
		self.addImportingItems()
		
	def addGeneralItems(self):
		page = self.addPage(i18n("&General"))
		vl = QVBoxLayout(page)
		self.rotateGroup = QButtonGroup(i18n("Default Rotation"), page)
		self.rotateGroup.setColumns(1)
		vl.addWidget(self.rotateGroup)
		self.radioRotate = QRadioButton(i18n("Clockwise"), self.rotateGroup, "rotateClockwise")
		self.radioRotateCounter = QRadioButton(i18n("Counter Clockwise"), self.rotateGroup, "rotateCounterClockwise")
		
	def addImportingItems(self):
		page = self.addPage(i18n("&Importing"))
		vl = QVBoxLayout(page)
		self.cameraGroup = QButtonGroup(i18n("Camera Import"), page)
		self.cameraGroup.setColumns(1)
		vl.addWidget(self.cameraGroup)
		self.radioAsk = QRadioButton(i18n("Leave images on the camera"), self.cameraGroup, "cameraNoDelete")
		self.radioAsk = QRadioButton(i18n("Delete images from the camera"), self.cameraGroup, "cameraDelete")
		self.radioAsk = QRadioButton(i18n("Ask"), self.cameraGroup, "cameraAsk")
		self.fileGroup = QButtonGroup(i18n("File Import"), page)
		self.fileGroup.setColumns(1)
		vl.addWidget(self.fileGroup)
		self.radioAsk = QRadioButton(i18n("Leave original files"), self.fileGroup, "fileNoDelete")
		self.radioAsk = QRadioButton(i18n("Delete files after import"), self.fileGroup, "fileDelete")
		self.radioAsk = QRadioButton(i18n("Ask"), self.fileGroup, "fileAsk")
		
