/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/utsname.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "hotlist.h"
#include "share2.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"
#include "log.h"
#include "wizard.h"
#include "string_list.h"
#include "utils.h"
#include "dialog.h"

#define PAGES   5

struct _wizard_widget_t {
  GtkWidget* win;
  GtkWidget* top_label;
  GtkWidget* help_frame;
  GtkWidget* help_button;
  GtkWidget* help_label;
  GtkWidget* prev_button;
  GtkWidget* next_button;
  GtkWidget* notebook;
  // page 1
  GtkWidget* page1_entry[3];
  // page 2
  GtkWidget* page2_entry[2];
  GtkWidget* page2_radio[2];
  GtkWidget* port_spin;
  // page 3
  GtkWidget* page3_entry[6];
  // page 4
  GtkWidget* page4_entry[8];
  // page 5
  GtkWidget* clist;

  int page;
  int browse_mime;
  GtkWidget* browse_entry;
} ww;

static GtkWidget* create_wizard (void);

static void wizard_print_help() {
  GtkLabel *label;

  label = GTK_LABEL(ww.help_label);
  switch (ww.page) {
  case 1:
    gtk_label_set_text(label,
		       "Just enter a username and a password, make sure that you do not include spaces!");
    break;
  case 2:
    gtk_label_set_text(label,
		       "The specified linespeed will be shown to others, if they request your information. It is not important to select the correct speed, but it would be fair to the others.\nYou may set the dataport to every port that is reachable for the rest of the world, if there is no such port (firewalled), then select 0 instead.");
    break;
  case 3:
    gtk_label_set_text(label,
		       "This are the file suffixes that will be known by Lopster. You can bind each of them to an external application in the preferences later.");
    break;
  case 4:
    gtk_label_set_text(label,
		       "Lopster needs to know where it should store the downloaded files. While downloading they will be saved in the incomplete Folder, when finished they will be moved to the folder according to its suffix. At least setup the default path and the folder for incomplete files.");
    break;
  case 5:
    gtk_label_set_text(label,
		       "Setup your shared library here. Lopster will scan the specified directories recursively for files that are known (section Suffixes).");
    break;
  }
}

static void wizard_setup_page() {
  GtkButton *button;
  GtkLabel* label;

  label = GTK_LABEL(ww.top_label);
  switch (ww.page) {
  case 1:
    gtk_label_set_text(label, "User Settings");
    break;
  case 2:
    gtk_label_set_text(label, "Network Settings");
    break;
  case 3:
    gtk_label_set_text(label, "Suffixes for Mediatypes");
    break;
  case 4:
    gtk_label_set_text(label, "Download Paths");
    break;
  case 5:
    gtk_label_set_text(label, "Shared Folders");
    break;
  }

  if (ww.page == 1)
    gtk_widget_set_sensitive(ww.prev_button, FALSE);
  else
    gtk_widget_set_sensitive(ww.prev_button, TRUE);

  button = GTK_BUTTON(ww.next_button);
  if (ww.page == PAGES)
    gtk_label_set_text(GTK_LABEL(button->child), "Finish");
  else
    gtk_label_set_text(GTK_LABEL(button->child), "Next >>");

  wizard_print_help();
}

void wizard_start() {
  ww.win = create_wizard();
  ww.page = 1;

  wizard_setup_page();
  gtk_my_widget_show(ww.win);
}

static int wizard_check_current() {
  GtkEntry* entry;
  char *text;
  char *text2;

  switch (ww.page) {
  case 1:
    entry = GTK_ENTRY(ww.page1_entry[0]);
    text = gtk_entry_get_text(entry);
    if (strlen(text) < 1) {
      info_dialog("Nickname must not be empty");
      return 0;
    }
    if (strchr(text, ' ')) {
      info_dialog("Nickname must not contain any spaces");
      return 0;
    }

    entry = GTK_ENTRY(ww.page1_entry[1]);
    text = gtk_entry_get_text(entry);
    entry = GTK_ENTRY(ww.page1_entry[2]);
    text2 = gtk_entry_get_text(entry);
    if (strlen(text) < 1) {
      info_dialog("Password must be empty");
      return 0;
    }
    if (strcmp(text, text2)) {
      info_dialog("Passwords do not match");
      return 0;
    }
    if (strchr(text, ' ')) {
      info_dialog("The password must not contain any spaces");
      return 0;
    }
    return 1;
    break;
  case 2:
  case 3:
    return 1;
    break;
  case 4:
    entry = GTK_ENTRY(ww.page4_entry[0]);
    text = gtk_entry_get_text(entry);
    if (*text == 0) {
      info_dialog("You must specify an incomplete folder");
      return 0;
    }
    entry = GTK_ENTRY(ww.page4_entry[1]);
    text = gtk_entry_get_text(entry);
    if (*text == 0) {
      info_dialog("You must specify a default download folder");
      return 0;
    }
    return 1;
    break;
  case 5:
  default:
    return 1;
    break;
  }
  return 1;
}

static void wizard_previous() {
  if (ww.page > 1) {
    gtk_notebook_prev_page(GTK_NOTEBOOK(ww.notebook));
    ww.page--;
  }
  wizard_setup_page();
}

static void wizard_finish() {
  command_make_alias("msg", "whisper");
  command_make_alias("join", "j");
  command_make_alias("part", "p");
  command_make_alias("me", "emote");
  command_make_alias("away", "afk");

  if (global.incomplete_path)
    create_dir(global.incomplete_path);

  write_rc();
  lib_refresh(global.lib);

  gtk_widget_destroy(ww.win);
}

static void wizard_apply_current() {
  GtkEntry* entry;
  GtkSpinButton* spin;
  GtkToggleButton* toggle;
  char *text;
  char *text2;
  suffix_t *suffix;
  int mime, i1, i2;

  switch (ww.page) {
  case 1:
    entry = GTK_ENTRY(ww.page1_entry[0]);
    text = gtk_entry_get_text(entry);
    global.username = l_strdup(text);
    entry = GTK_ENTRY(ww.page1_entry[1]);
    text = gtk_entry_get_text(entry);
    global.password = l_strdup(text);
    break;
  case 2:
    entry = GTK_ENTRY(ww.page2_entry[0]);
    text = gtk_entry_get_text(entry);
    global.linespeed = speed2int(text);

    entry = GTK_ENTRY(ww.page2_entry[1]);
    text = strdup(gtk_entry_get_text(entry));
    destroy_string_list(global.allowed_ports);
    global.allowed_ports = create_allowed_ports(text);
    free(text);

    toggle = GTK_TOGGLE_BUTTON(ww.page2_radio[0]);
    if (gtk_toggle_button_get_active(toggle)) i2 = 1;
    else i2 = 0;
    toggle = GTK_TOGGLE_BUTTON(ww.page2_radio[1]);
    if (gtk_toggle_button_get_active(toggle))
      i2 = 0;
    spin = GTK_SPIN_BUTTON(ww.port_spin);
    i1 = gtk_spin_button_get_value_as_int(spin);
    
    global.network.port = i1;
    global.network.firewall = i2;
    create_upload_port(i1, TRUE);
    break;
  case 3:
    clear_suffixes();
    entry = GTK_ENTRY(ww.page3_entry[0]);
    text = l_strdup(gtk_entry_get_text(entry));
    text2 = arg(text, 0);
    while (text2) {
      suffix = l_malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 1;
      global.mimetype[MIME_MP3].suffixes =
	g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    
    entry = GTK_ENTRY(ww.page3_entry[1]);
    text = l_strdup(gtk_entry_get_text(entry));
    text2 = arg(text, 0);
    while (text2) {
      suffix = l_malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_VIDEO].suffixes =
	  g_list_append(global.mimetype[MIME_VIDEO].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);

    entry = GTK_ENTRY(ww.page3_entry[2]);
    text = l_strdup(gtk_entry_get_text(entry));
    text2 = arg(text, 0);
    while (text2) {
      suffix = l_malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_AUDIO].suffixes =
	g_list_append(global.mimetype[MIME_AUDIO].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);

    entry = GTK_ENTRY(ww.page3_entry[3]);
    text = l_strdup(gtk_entry_get_text(entry));
    text2 = arg(text, 0);
    while (text2) {
      suffix = l_malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_APPLICATION].suffixes =
	  g_list_append(global.mimetype[MIME_APPLICATION].suffixes,
			suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);

    entry = GTK_ENTRY(ww.page3_entry[4]);
    text = l_strdup(gtk_entry_get_text(entry));
    text2 = arg(text, 0);
    while (text2) {
      suffix = l_malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_IMAGE].suffixes =
	  g_list_append(global.mimetype[MIME_IMAGE].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);

    entry = GTK_ENTRY(ww.page3_entry[5]);
    text = l_strdup(gtk_entry_get_text(entry));
    text2 = arg(text, 0);
    while (text2) {
      suffix = l_malloc(sizeof(suffix_t));
      suffix->suffix = l_strdup(text2);
      suffix->application = l_strdup("");
      suffix->as_mp3 = 0;
      global.mimetype[MIME_TEXT].suffixes =
	  g_list_append(global.mimetype[MIME_TEXT].suffixes, suffix);
      text2 = arg(NULL, 0);
    }
    l_free(text);
    break;
  case 4:
    entry = GTK_ENTRY(ww.page4_entry[0]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.incomplete_path)
      l_free(global.incomplete_path);
    global.incomplete_path = text;

    entry = GTK_ENTRY(ww.page4_entry[1]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_NONE].download)
      l_free(global.mimetype[MIME_NONE].download);
    global.mimetype[MIME_NONE].download = text;

    entry = GTK_ENTRY(ww.page4_entry[2]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_MP3].download)
      l_free(global.mimetype[MIME_MP3].download);
    global.mimetype[MIME_MP3].download = text;

    entry = GTK_ENTRY(ww.page4_entry[3]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_VIDEO].download)
      l_free(global.mimetype[MIME_VIDEO].download);
    global.mimetype[MIME_VIDEO].download = text;

    entry = GTK_ENTRY(ww.page4_entry[4]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_AUDIO].download)
      l_free(global.mimetype[MIME_AUDIO].download);
    global.mimetype[MIME_AUDIO].download = text;

    entry = GTK_ENTRY(ww.page4_entry[5]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_APPLICATION].download)
      l_free(global.mimetype[MIME_APPLICATION].download);
    global.mimetype[MIME_APPLICATION].download = text;

    entry = GTK_ENTRY(ww.page4_entry[6]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_IMAGE].download)
      l_free(global.mimetype[MIME_IMAGE].download);
    global.mimetype[MIME_IMAGE].download = text;

    entry = GTK_ENTRY(ww.page4_entry[7]);
    text = l_strdup(gtk_entry_get_text(entry));
    if (global.mimetype[MIME_TEXT].download)
      l_free(global.mimetype[MIME_TEXT].download);
    global.mimetype[MIME_TEXT].download = text;
    break;
  case 5:
    if (global.lib) {
      shared_folder_destroy(global.lib->shared_folder);
      global.lib->shared_folder = NULL;
    } else {
      global.lib = lib_new("shared.list");
    }
    for (i1 = 0; i1 < GTK_CLIST(ww.clist)->rows; i1++) {
      gtk_clist_get_text(GTK_CLIST(ww.clist), i1, 0, &text);
      mime = mime2int(text);
      gtk_clist_get_text(GTK_CLIST(ww.clist), i1, 1, &text);
      text2 = l_strdup(text);
      if (text2[strlen(text2) - 1] == DIR_SEP)
	text2[strlen(text2) - 1] = 0;
      lib_add_folder(global.lib, text2, mime);
      l_free(text2);
    }
    break;
  }
}

static void wizard_next() {
  if (!wizard_check_current()) return;

  wizard_apply_current();
  
  if (ww.page < PAGES) {
    gtk_notebook_next_page(GTK_NOTEBOOK(ww.notebook));
    ww.page++;
    wizard_setup_page();
  } else {
    wizard_finish();
  }
}

static void wizard_help() {
  GtkButton *button;

  button = GTK_BUTTON(ww.help_button);

  if (GTK_WIDGET_VISIBLE(ww.help_frame)) {
    gtk_widget_hide(ww.help_frame);
    gtk_label_set_text(GTK_LABEL(button->child), " Show Help ");
  } else {
    gtk_widget_show(ww.help_frame);
    gtk_label_set_text(GTK_LABEL(button->child), " Hide Help ");
  }
}

static void on_wizard_dir_select2(gchar * dir) {

  strcpy(list[0], MimeNames(ww.browse_mime, 1));
  strcpy(list[1], dir);
  if (list[1][strlen(list[1]) - 1] == DIR_SEP)
    list[1][strlen(list[1]) - 1] = 0;
  gtk_clist_append(GTK_CLIST(ww.clist), list);
}

static void on_folder_add(GtkMenuItem * menuitem ATTR_UNUSED,
			  gpointer user_data) {
  GtkWidget *win;

  ww.browse_mime = (int) user_data;
  win = create_dir_browser("Select Directory", g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_wizard_dir_select2);
  gtk_widget_show(win);
}

static GtkWidget *create_wizard_popup() {
  GtkWidget *popup;
  GtkAccelGroup *popup_accels;
  GtkWidget *item;

  popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(popup));

  item = gtk_menu_item_new_with_label("MP3");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add), 
		     (gpointer) MIME_MP3);
  
  item = gtk_menu_item_new_with_label("Video");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_VIDEO);

  item = gtk_menu_item_new_with_label("Audio");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_AUDIO);

  item = gtk_menu_item_new_with_label("Application");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_APPLICATION);

  item = gtk_menu_item_new_with_label("Image");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add),
		     (gpointer) MIME_IMAGE);

  item = gtk_menu_item_new_with_label("Text");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add), (gpointer) MIME_TEXT);

  item = gtk_menu_item_new_with_label("All Files");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_folder_add), (gpointer) MIME_NONE);

  return popup;
}

static void wizard_clear_selected() {
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(ww.clist);
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}

static void 
on_wizard_destroy(GtkObject* object,
		  gpointer user_data ATTR_UNUSED) {
  gtk_widget_destroy(GTK_WIDGET(object));
}


static void on_wizard_dir_select(gchar * dir) {
  gchar *dir2;

  dir2 = l_strdup(dir);
  if (dir2[strlen(dir2) - 1] == DIR_SEP)
    dir2[strlen(dir2) - 1] = 0;
  gtk_entry_set_text(GTK_ENTRY(ww.browse_entry), dir2);
  l_free(dir2);
}

static void
on_button_browse_clicked(GtkButton* button ATTR_UNUSED,
			 gpointer user_data) {
  GtkWidget *win;

  ww.browse_entry = user_data;
  win = create_dir_browser("Select Directory", g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_wizard_dir_select);
  gtk_widget_show(win);
}


static void
on_radio_port_toggled (GtkToggleButton *togglebutton,
		       gpointer         user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(ww.page2_entry[1], TRUE);
    gtk_widget_set_sensitive(ww.port_spin, TRUE);
  } else {
    gtk_widget_set_sensitive(ww.page2_entry[1], FALSE);
    gtk_widget_set_sensitive(ww.port_spin, FALSE);
  }
}

void popup_position(GtkMenu * menu, gint * x, gint * y, 
		    gpointer user_data);

static void
on_button_add_clicked(GtkButton * button,
		      gpointer user_data ATTR_UNUSED) {
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_wizard_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, 
		 button, 1, 0);
}

static void
on_button_clear_clicked(GtkButton * button ATTR_UNUSED,
			gpointer user_data ATTR_UNUSED) {
  wizard_clear_selected();
}

static void
on_button_next_clicked(GtkButton * button ATTR_UNUSED,
		       gpointer user_data ATTR_UNUSED) {
  wizard_next();
}

static void
on_button_prev_clicked(GtkButton * button ATTR_UNUSED,
		       gpointer user_data ATTR_UNUSED) {
  wizard_previous();
}

static void
on_button_help_clicked(GtkButton * button ATTR_UNUSED,
		       gpointer user_data ATTR_UNUSED) {
  wizard_help();
}


static GtkWidget* create_wizard (void) {
  GtkWidget *wizard;
  GtkWidget* vbox;
  GtkWidget* vbox2;
  GtkWidget* hbox;
  GtkWidget* hbox2;
  GtkWidget* label;
  GtkWidget* entry;
  GtkWidget* button;
  GtkWidget* frame;
  GtkWidget* notebook;
  GtkWidget* spinbutton;
  GtkWidget* clist;
  GtkWidget* scrolledwindow;
  GtkWidget* table;
  GtkWidget* sep;
  GtkWidget* vbox3;
  GtkWidget* radiobutton;
  GtkWidget* combo;
  GtkObject* adj;
  GList* combo_items;
  GSList* dp_group;

  wizard = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (wizard), "wizard", wizard);
  gtk_window_set_title (GTK_WINDOW (wizard), "Setup Wizard");
  gtk_window_set_default_size (GTK_WINDOW (wizard), 420, -1);
  gtk_window_set_policy (GTK_WINDOW (wizard), FALSE, TRUE, TRUE);

  gtk_signal_connect (GTK_OBJECT (wizard), "destroy",
                      GTK_SIGNAL_FUNC (on_wizard_destroy),
                      NULL);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (wizard), vbox);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (vbox2), frame, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
  
  label = gtk_label_new ("User Settings");
  gtk_widget_show (label);
  gtk_container_add (GTK_CONTAINER (frame), label);
  ww.top_label = label;

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (vbox2), frame, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);

  notebook = gtk_notebook_new ();
  gtk_widget_show (notebook);
  gtk_container_add (GTK_CONTAINER (frame), notebook);
  gtk_container_set_border_width (GTK_CONTAINER (notebook), 5);
  GTK_WIDGET_UNSET_FLAGS (notebook, GTK_CAN_FOCUS);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (notebook), FALSE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_BOTTOM);
  ww.notebook = notebook;

  frame = gtk_frame_new (NULL);
  gtk_widget_hide (frame);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  ww.help_frame = frame;

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

  label = gtk_label_new ("");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_set_usize (label, 380, -2);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  ww.help_label = label;

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);

  hbox = gtk_hbox_new (TRUE, 10);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (frame), hbox);

  hbox2 = gtk_hbox_new (TRUE, 10);
  gtk_widget_show (hbox2);
  gtk_box_pack_end (GTK_BOX (hbox), hbox2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 3);

  button = gtk_button_new_with_label (" Next >> ");
  gtk_widget_show (button);
  gtk_box_pack_end (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
  ww.next_button = button;
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_next_clicked),
                      NULL);

  button = gtk_button_new_with_label (" << Previous ");
  gtk_widget_show (button);
  gtk_box_pack_end (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (button, FALSE);
  ww.prev_button = button;
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_prev_clicked),
                      NULL);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (hbox), hbox2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 3);

  button = gtk_button_new_with_label (" Show Help ");
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox2), button, FALSE, FALSE, 0);
  ww.help_button = button;
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_help_clicked),
                      NULL);

  // now the notebook contents
  // page 1
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (notebook), vbox);

  table = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, FALSE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Default username");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_set_style(label, global.styles[STYLE_PREF]);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Password");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_set_style(label, global.styles[STYLE_PREF]);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Retype password");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_set_style(label, global.styles[STYLE_PREF]);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page1_entry[0] = entry;

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (entry), FALSE);
  ww.page1_entry[1] = entry;

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (entry), FALSE);
  ww.page1_entry[2] = entry;

  label = gtk_label_new ("Page 1");
  gtk_widget_show (label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label);

  // page 2
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (notebook), vbox);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (vbox), vbox2, TRUE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);

  label = gtk_label_new ("Your Line Speed");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  
  combo = gtk_combo_new ();
  gtk_widget_show (combo);
  gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 0);
  combo_items = NULL;
  combo_items = g_list_append (combo_items, (gpointer) "unknown");
  combo_items = g_list_append (combo_items, (gpointer) "14.4 kbps");
  combo_items = g_list_append (combo_items, (gpointer) "28.8 kbps");
  combo_items = g_list_append (combo_items, (gpointer) "33.6 kbps");
  combo_items = g_list_append (combo_items, (gpointer) "56 kbps");
  combo_items = g_list_append (combo_items, (gpointer) "64K ISDN");
  combo_items = g_list_append (combo_items, (gpointer) "128K ISDN");
  combo_items = g_list_append (combo_items, (gpointer) "Cable");
  combo_items = g_list_append (combo_items, (gpointer) "DSL");
  combo_items = g_list_append (combo_items, (gpointer) "T1");
  combo_items = g_list_append (combo_items, (gpointer) "T3+");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
  g_list_free (combo_items);

  entry = GTK_COMBO (combo)->entry;
  gtk_widget_show (entry);
  gtk_entry_set_editable (GTK_ENTRY (entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), "unknown");
  ww.page2_entry[0] = entry;

  sep = gtk_hseparator_new ();
  gtk_widget_show (sep);
  gtk_box_pack_start (GTK_BOX (vbox2), sep, TRUE, TRUE, 5);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox3, FALSE, FALSE, 0);

  dp_group = NULL;
  radiobutton =
    gtk_radio_button_new_with_label (dp_group, 
				     "I cannot accept direct connections (firewall)");
  dp_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_widget_show (radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox3), radiobutton, FALSE, FALSE, 0);
  ww.page2_radio[0] = radiobutton;

  radiobutton = 
    gtk_radio_button_new_with_label (dp_group,
				     "I can accept direct connections");
  dp_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_widget_show (radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox3), radiobutton, FALSE, FALSE, 0);
  ww.page2_radio[1] = radiobutton;
  gtk_signal_connect (GTK_OBJECT (radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_radio_port_toggled),
                      NULL);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox, TRUE, TRUE, 0);

  table = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 20);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Default Dataport");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Available Dataports");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  adj = gtk_adjustment_new (6699, 1024, 65535, 1, 10, 10);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gtk_widget_show (spinbutton);
  gtk_table_attach (GTK_TABLE (table), spinbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.port_spin = spinbutton;

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_text (GTK_ENTRY (entry), "6680-6699");
  ww.page2_entry[1] = entry;

  label = gtk_label_new ("Page 2");
  gtk_widget_show (label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label);

  // page 3
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (notebook), vbox);

  table = gtk_table_new (6, 2, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, FALSE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("MP3 files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Video files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Audio files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Application files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Image files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Text files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page3_entry[0] = entry;
#ifdef HAVE_OGG
  gtk_entry_set_text (GTK_ENTRY (entry), "mp3 ogg");
#else
  gtk_entry_set_text (GTK_ENTRY (entry), "mp3");
#endif

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page3_entry[1] = entry;
  gtk_entry_set_text(GTK_ENTRY(entry), "mpg mpeg avi asf mov wmf rm ram");

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page3_entry[2] = entry;
#ifdef HAVE_OGG
  gtk_entry_set_text(GTK_ENTRY(entry), "wav au");
#else
  gtk_entry_set_text(GTK_ENTRY(entry), "wav au ogg");
#endif

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page3_entry[3] = entry;
  gtk_entry_set_text(GTK_ENTRY(entry), "tgz tar gz exe bz2 zip rpm dep dll");

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page3_entry[4] = entry;
  gtk_entry_set_text(GTK_ENTRY(entry), "jpg jpeg bmp gif png");

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page3_entry[5] = entry;
  gtk_entry_set_text(GTK_ENTRY(entry), "txt dvi ps doc pdf");

  label = gtk_label_new ("Page 3");
  gtk_widget_show (label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 2), label);

  // page 4
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (notebook), vbox);

  table = gtk_table_new (9, 3, FALSE);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, TRUE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table), 3);


  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Incomplete files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_set_style(label, global.styles[STYLE_PREF]);

  sep = gtk_hseparator_new ();
  gtk_widget_show (sep);
  gtk_table_attach (GTK_TABLE (table), sep, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 4);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Default path");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_set_style(label, global.styles[STYLE_PREF]);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("MP3 files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Video files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Audio files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);


  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Application files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Image files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  label = gtk_label_new ("Text files");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[0] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[1] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[2] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[3] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[4] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[5] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[6] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  entry = gtk_entry_new ();
  gtk_widget_show (entry);
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 8, 9,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  ww.page4_entry[7] = entry;
  button = gtk_button_new_with_label (" Select ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (table), button, 2, 3, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_browse_clicked),
                      entry);

  label = gtk_label_new ("Page 4");
  gtk_widget_show (label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 3), label);

  // page 5
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (notebook), vbox);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist = gtk_clist_new (2);
  gtk_widget_show (clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), clist);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_MULTIPLE);
  gtk_clist_column_titles_show (GTK_CLIST (clist));
  ww.clist = clist;

  label = gtk_label_new ("Type");
  gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 0, label);
  
  label = gtk_label_new ("Folder");
  gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 1, label);

  hbox = gtk_hbox_new (TRUE, 50);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  
  button = gtk_button_new_with_label ("Add Folder");
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_add_clicked),
                      NULL);

  button = gtk_button_new_with_label ("Remove selected");
  gtk_widget_show (button);
  gtk_box_pack_end (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_button_clear_clicked),
                      NULL);

  label = gtk_label_new ("Page 5");
  gtk_widget_show (label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), 
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 4), label);

  return wizard;
}

